package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface EnvVarFluent<A extends EnvVarFluent<A>> extends Fluent<A> {


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
    public String getValue();
    public A withValue(String value);
    public Boolean hasValue();
    public A withNewValue(StringBuilder arg1);
    public A withNewValue(int[] arg1,int arg2,int arg3);
    public A withNewValue(char[] arg1);
    public A withNewValue(StringBuffer arg1);
    public A withNewValue(byte[] arg1,int arg2);
    public A withNewValue(byte[] arg1);
    public A withNewValue(char[] arg1,int arg2,int arg3);
    public A withNewValue(byte[] arg1,int arg2,int arg3);
    public A withNewValue(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewValue(String arg1);
    
/**
 * This method has been deprecated, please use method buildValueFrom instead.
 * @return The buildable object.
 */
@Deprecated public EnvVarSource getValueFrom();
    public EnvVarSource buildValueFrom();
    public A withValueFrom(EnvVarSource valueFrom);
    public Boolean hasValueFrom();
    public EnvVarFluent.ValueFromNested<A> withNewValueFrom();
    public EnvVarFluent.ValueFromNested<A> withNewValueFromLike(EnvVarSource item);
    public EnvVarFluent.ValueFromNested<A> editValueFrom();
    public EnvVarFluent.ValueFromNested<A> editOrNewValueFrom();
    public EnvVarFluent.ValueFromNested<A> editOrNewValueFromLike(EnvVarSource item);
    public interface ValueFromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvVarSourceFluent<EnvVarFluent.ValueFromNested<N>> {

            public N and();
            public N endValueFrom();    }


}
