package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServiceBuilder extends APIServiceFluentImpl<APIServiceBuilder> implements VisitableBuilder<APIService,APIServiceBuilder> {

    APIServiceFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceBuilder() {
        this(true);
    }

    public APIServiceBuilder(Boolean validationEnabled) {
        this(new APIService(), validationEnabled);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent) {
        this(fluent, true);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new APIService(), validationEnabled);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent,APIService instance) {
        this(fluent, instance, true);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent,APIService instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServiceBuilder(APIService instance) {
        this(instance,true);
    }

    public APIServiceBuilder(APIService instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIService build() {
        APIService buildable = new APIService(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServiceBuilder that = (APIServiceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
