package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;
import java.lang.StringBuffer;

public class PodSpecFluentImpl<A extends PodSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodSpecFluent<A> {

    private Long activeDeadlineSeconds;
    private AffinityBuilder affinity;
    private Boolean automountServiceAccountToken;
    private List<ContainerBuilder> containers =  new ArrayList<ContainerBuilder>();
    private PodDNSConfigBuilder dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private List<EphemeralContainerBuilder> ephemeralContainers =  new ArrayList<EphemeralContainerBuilder>();
    private List<HostAliasBuilder> hostAliases =  new ArrayList<HostAliasBuilder>();
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private String hostname;
    private List<LocalObjectReferenceBuilder> imagePullSecrets =  new ArrayList<LocalObjectReferenceBuilder>();
    private List<ContainerBuilder> initContainers =  new ArrayList<ContainerBuilder>();
    private String nodeName;
    private Map<String,String> nodeSelector;
    private Map<String,Quantity> overhead;
    private String preemptionPolicy;
    private Integer priority;
    private String priorityClassName;
    private List<PodReadinessGateBuilder> readinessGates =  new ArrayList<PodReadinessGateBuilder>();
    private String restartPolicy;
    private String runtimeClassName;
    private String schedulerName;
    private PodSecurityContextBuilder securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean setHostnameAsFQDN;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private List<TolerationBuilder> tolerations =  new ArrayList<TolerationBuilder>();
    private List<TopologySpreadConstraintBuilder> topologySpreadConstraints =  new ArrayList<TopologySpreadConstraintBuilder>();
    private List<VolumeBuilder> volumes =  new ArrayList<VolumeBuilder>();

    public PodSpecFluentImpl() {
    }

    public PodSpecFluentImpl(PodSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
        this.withAffinity(instance.getAffinity()); 
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken()); 
        this.withContainers(instance.getContainers()); 
        this.withDnsConfig(instance.getDnsConfig()); 
        this.withDnsPolicy(instance.getDnsPolicy()); 
        this.withEnableServiceLinks(instance.getEnableServiceLinks()); 
        this.withEphemeralContainers(instance.getEphemeralContainers()); 
        this.withHostAliases(instance.getHostAliases()); 
        this.withHostIPC(instance.getHostIPC()); 
        this.withHostNetwork(instance.getHostNetwork()); 
        this.withHostPID(instance.getHostPID()); 
        this.withHostname(instance.getHostname()); 
        this.withImagePullSecrets(instance.getImagePullSecrets()); 
        this.withInitContainers(instance.getInitContainers()); 
        this.withNodeName(instance.getNodeName()); 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withOverhead(instance.getOverhead()); 
        this.withPreemptionPolicy(instance.getPreemptionPolicy()); 
        this.withPriority(instance.getPriority()); 
        this.withPriorityClassName(instance.getPriorityClassName()); 
        this.withReadinessGates(instance.getReadinessGates()); 
        this.withRestartPolicy(instance.getRestartPolicy()); 
        this.withRuntimeClassName(instance.getRuntimeClassName()); 
        this.withSchedulerName(instance.getSchedulerName()); 
        this.withSecurityContext(instance.getSecurityContext()); 
        this.withServiceAccount(instance.getServiceAccount()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN()); 
        this.withShareProcessNamespace(instance.getShareProcessNamespace()); 
        this.withSubdomain(instance.getSubdomain()); 
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
        this.withTolerations(instance.getTolerations()); 
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
        this.withVolumes(instance.getVolumes()); 
    }

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
    }

    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    public A withNewActiveDeadlineSeconds(String arg1) {
        return (A)withActiveDeadlineSeconds(new Long(arg1));
    }

    public A withNewActiveDeadlineSeconds(long arg1) {
        return (A)withActiveDeadlineSeconds(new Long(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildAffinity instead.
 * @return The buildable object.
 */
@Deprecated public Affinity getAffinity() {
        return this.affinity!=null?this.affinity.build():null;
    }

    public Affinity buildAffinity() {
        return this.affinity!=null?this.affinity.build():null;
    }

    public A withAffinity(Affinity affinity) {
        _visitables.get("affinity").remove(this.affinity);
        if (affinity!=null){ this.affinity= new AffinityBuilder(affinity); _visitables.get("affinity").add(this.affinity);} return (A) this;
    }

    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    public PodSpecFluent.AffinityNested<A> withNewAffinity() {
        return new AffinityNestedImpl();
    }

    public PodSpecFluent.AffinityNested<A> withNewAffinityLike(Affinity item) {
        return new AffinityNestedImpl(item);
    }

    public PodSpecFluent.AffinityNested<A> editAffinity() {
        return withNewAffinityLike(getAffinity());
    }

    public PodSpecFluent.AffinityNested<A> editOrNewAffinity() {
        return withNewAffinityLike(getAffinity() != null ? getAffinity(): new AffinityBuilder().build());
    }

    public PodSpecFluent.AffinityNested<A> editOrNewAffinityLike(Affinity item) {
        return withNewAffinityLike(getAffinity() != null ? getAffinity(): item);
    }

    public Boolean isAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken=automountServiceAccountToken; return (A) this;
    }

    public Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    public A withNewAutomountServiceAccountToken(String arg1) {
        return (A)withAutomountServiceAccountToken(new Boolean(arg1));
    }

    public A withNewAutomountServiceAccountToken(boolean arg1) {
        return (A)withAutomountServiceAccountToken(new Boolean(arg1));
    }

    public A addToContainers(int index,Container item) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
    }

    public A setToContainers(int index,Container item) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
        if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
         return (A)this;
    }

    public A addToContainers(Container... items) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
    }

    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
    }

    public A removeFromContainers(Container... items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (containers == null) return (A) this;
        final Iterator<ContainerBuilder> each = containers.iterator();
        final List visitables = _visitables.get("containers");
        while (each.hasNext()) {
          ContainerBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getContainers() {
        return build(containers);
    }

    public List<Container> buildContainers() {
        return build(containers);
    }

    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public Container buildLastContainer() {
        return this.containers.get(containers.size() - 1).build();
    }

    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: containers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: containers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withContainers(List<Container> containers) {
        if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
        if (containers != null) {this.containers = new ArrayList<ContainerBuilder>(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
    }

    public A withContainers(Container... containers) {
        if (this.containers != null) {this.containers.clear();}
        if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
    }

    public Boolean hasContainers() {
        return containers != null && !containers.isEmpty();
    }

    public PodSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    public PodSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item) {
        return new ContainersNestedImpl(index, item);
    }

    public PodSpecFluent.ContainersNested<A> editContainer(int index) {
        if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
        return setNewContainerLike(index, buildContainer(index));
    }

    public PodSpecFluent.ContainersNested<A> editFirstContainer() {
        if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
        return setNewContainerLike(0, buildContainer(0));
    }

    public PodSpecFluent.ContainersNested<A> editLastContainer() {
        int index = containers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
        return setNewContainerLike(index, buildContainer(index));
    }

    public PodSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<containers.size();i++) { 
        if (predicate.test(containers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
        return setNewContainerLike(index, buildContainer(index));
    }

    
/**
 * This method has been deprecated, please use method buildDnsConfig instead.
 * @return The buildable object.
 */
@Deprecated public PodDNSConfig getDnsConfig() {
        return this.dnsConfig!=null?this.dnsConfig.build():null;
    }

    public PodDNSConfig buildDnsConfig() {
        return this.dnsConfig!=null?this.dnsConfig.build():null;
    }

    public A withDnsConfig(PodDNSConfig dnsConfig) {
        _visitables.get("dnsConfig").remove(this.dnsConfig);
        if (dnsConfig!=null){ this.dnsConfig= new PodDNSConfigBuilder(dnsConfig); _visitables.get("dnsConfig").add(this.dnsConfig);} return (A) this;
    }

    public Boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    public PodSpecFluent.DnsConfigNested<A> withNewDnsConfig() {
        return new DnsConfigNestedImpl();
    }

    public PodSpecFluent.DnsConfigNested<A> withNewDnsConfigLike(PodDNSConfig item) {
        return new DnsConfigNestedImpl(item);
    }

    public PodSpecFluent.DnsConfigNested<A> editDnsConfig() {
        return withNewDnsConfigLike(getDnsConfig());
    }

    public PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfig() {
        return withNewDnsConfigLike(getDnsConfig() != null ? getDnsConfig(): new PodDNSConfigBuilder().build());
    }

    public PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfigLike(PodDNSConfig item) {
        return withNewDnsConfigLike(getDnsConfig() != null ? getDnsConfig(): item);
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy=dnsPolicy; return (A) this;
    }

    public Boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    public A withNewDnsPolicy(String arg1) {
        return (A)withDnsPolicy(new String(arg1));
    }

    public A withNewDnsPolicy(StringBuilder arg1) {
        return (A)withDnsPolicy(new String(arg1));
    }

    public A withNewDnsPolicy(StringBuffer arg1) {
        return (A)withDnsPolicy(new String(arg1));
    }

    public Boolean isEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks=enableServiceLinks; return (A) this;
    }

    public Boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    public A withNewEnableServiceLinks(String arg1) {
        return (A)withEnableServiceLinks(new Boolean(arg1));
    }

    public A withNewEnableServiceLinks(boolean arg1) {
        return (A)withEnableServiceLinks(new Boolean(arg1));
    }

    public A addToEphemeralContainers(int index,EphemeralContainer item) {
        if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainerBuilder>();}
        EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);_visitables.get("ephemeralContainers").add(index >= 0 ? index : _visitables.get("ephemeralContainers").size(), builder);this.ephemeralContainers.add(index >= 0 ? index : ephemeralContainers.size(), builder); return (A)this;
    }

    public A setToEphemeralContainers(int index,EphemeralContainer item) {
        if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainerBuilder>();}
        EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
        if (index < 0 || index >= _visitables.get("ephemeralContainers").size()) { _visitables.get("ephemeralContainers").add(builder); } else { _visitables.get("ephemeralContainers").set(index, builder);}
        if (index < 0 || index >= ephemeralContainers.size()) { ephemeralContainers.add(builder); } else { ephemeralContainers.set(index, builder);}
         return (A)this;
    }

    public A addToEphemeralContainers(EphemeralContainer... items) {
        if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainerBuilder>();}
        for (EphemeralContainer item : items) {EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);_visitables.get("ephemeralContainers").add(builder);this.ephemeralContainers.add(builder);} return (A)this;
    }

    public A addAllToEphemeralContainers(Collection<EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainerBuilder>();}
        for (EphemeralContainer item : items) {EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);_visitables.get("ephemeralContainers").add(builder);this.ephemeralContainers.add(builder);} return (A)this;
    }

    public A removeFromEphemeralContainers(EphemeralContainer... items) {
        for (EphemeralContainer item : items) {EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);_visitables.get("ephemeralContainers").remove(builder);if (this.ephemeralContainers != null) {this.ephemeralContainers.remove(builder);}} return (A)this;
    }

    public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items) {
        for (EphemeralContainer item : items) {EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);_visitables.get("ephemeralContainers").remove(builder);if (this.ephemeralContainers != null) {this.ephemeralContainers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEphemeralContainers(Predicate<EphemeralContainerBuilder> predicate) {
        if (ephemeralContainers == null) return (A) this;
        final Iterator<EphemeralContainerBuilder> each = ephemeralContainers.iterator();
        final List visitables = _visitables.get("ephemeralContainers");
        while (each.hasNext()) {
          EphemeralContainerBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEphemeralContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<EphemeralContainer> getEphemeralContainers() {
        return build(ephemeralContainers);
    }

    public List<EphemeralContainer> buildEphemeralContainers() {
        return build(ephemeralContainers);
    }

    public EphemeralContainer buildEphemeralContainer(int index) {
        return this.ephemeralContainers.get(index).build();
    }

    public EphemeralContainer buildFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0).build();
    }

    public EphemeralContainer buildLastEphemeralContainer() {
        return this.ephemeralContainers.get(ephemeralContainers.size() - 1).build();
    }

    public EphemeralContainer buildMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
        for (EphemeralContainerBuilder item: ephemeralContainers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
        for (EphemeralContainerBuilder item: ephemeralContainers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers) {
        if (this.ephemeralContainers != null) { _visitables.get("ephemeralContainers").removeAll(this.ephemeralContainers);}
        if (ephemeralContainers != null) {this.ephemeralContainers = new ArrayList<EphemeralContainerBuilder>(); for (EphemeralContainer item : ephemeralContainers){this.addToEphemeralContainers(item);}} else { this.ephemeralContainers = null;} return (A) this;
    }

    public A withEphemeralContainers(EphemeralContainer... ephemeralContainers) {
        if (this.ephemeralContainers != null) {this.ephemeralContainers.clear();}
        if (ephemeralContainers != null) {for (EphemeralContainer item :ephemeralContainers){ this.addToEphemeralContainers(item);}} return (A) this;
    }

    public Boolean hasEphemeralContainers() {
        return ephemeralContainers != null && !ephemeralContainers.isEmpty();
    }

    public PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainer() {
        return new EphemeralContainersNestedImpl();
    }

    public PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainerLike(EphemeralContainer item) {
        return new EphemeralContainersNestedImpl(-1, item);
    }

    public PodSpecFluent.EphemeralContainersNested<A> setNewEphemeralContainerLike(int index,EphemeralContainer item) {
        return new EphemeralContainersNestedImpl(index, item);
    }

    public PodSpecFluent.EphemeralContainersNested<A> editEphemeralContainer(int index) {
        if (ephemeralContainers.size() <= index) throw new RuntimeException("Can't edit ephemeralContainers. Index exceeds size.");
        return setNewEphemeralContainerLike(index, buildEphemeralContainer(index));
    }

    public PodSpecFluent.EphemeralContainersNested<A> editFirstEphemeralContainer() {
        if (ephemeralContainers.size() == 0) throw new RuntimeException("Can't edit first ephemeralContainers. The list is empty.");
        return setNewEphemeralContainerLike(0, buildEphemeralContainer(0));
    }

    public PodSpecFluent.EphemeralContainersNested<A> editLastEphemeralContainer() {
        int index = ephemeralContainers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last ephemeralContainers. The list is empty.");
        return setNewEphemeralContainerLike(index, buildEphemeralContainer(index));
    }

    public PodSpecFluent.EphemeralContainersNested<A> editMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<ephemeralContainers.size();i++) { 
        if (predicate.test(ephemeralContainers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching ephemeralContainers. No match found.");
        return setNewEphemeralContainerLike(index, buildEphemeralContainer(index));
    }

    public A addToHostAliases(int index,HostAlias item) {
        if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
        HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").add(index >= 0 ? index : _visitables.get("hostAliases").size(), builder);this.hostAliases.add(index >= 0 ? index : hostAliases.size(), builder); return (A)this;
    }

    public A setToHostAliases(int index,HostAlias item) {
        if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
        HostAliasBuilder builder = new HostAliasBuilder(item);
        if (index < 0 || index >= _visitables.get("hostAliases").size()) { _visitables.get("hostAliases").add(builder); } else { _visitables.get("hostAliases").set(index, builder);}
        if (index < 0 || index >= hostAliases.size()) { hostAliases.add(builder); } else { hostAliases.set(index, builder);}
         return (A)this;
    }

    public A addToHostAliases(HostAlias... items) {
        if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
        for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").add(builder);this.hostAliases.add(builder);} return (A)this;
    }

    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
        for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").add(builder);this.hostAliases.add(builder);} return (A)this;
    }

    public A removeFromHostAliases(HostAlias... items) {
        for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").remove(builder);if (this.hostAliases != null) {this.hostAliases.remove(builder);}} return (A)this;
    }

    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").remove(builder);if (this.hostAliases != null) {this.hostAliases.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate) {
        if (hostAliases == null) return (A) this;
        final Iterator<HostAliasBuilder> each = hostAliases.iterator();
        final List visitables = _visitables.get("hostAliases");
        while (each.hasNext()) {
          HostAliasBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHostAliases instead.
 * @return The buildable object.
 */
@Deprecated public List<HostAlias> getHostAliases() {
        return build(hostAliases);
    }

    public List<HostAlias> buildHostAliases() {
        return build(hostAliases);
    }

    public HostAlias buildHostAlias(int index) {
        return this.hostAliases.get(index).build();
    }

    public HostAlias buildFirstHostAlias() {
        return this.hostAliases.get(0).build();
    }

    public HostAlias buildLastHostAlias() {
        return this.hostAliases.get(hostAliases.size() - 1).build();
    }

    public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item: hostAliases) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item: hostAliases) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHostAliases(List<HostAlias> hostAliases) {
        if (this.hostAliases != null) { _visitables.get("hostAliases").removeAll(this.hostAliases);}
        if (hostAliases != null) {this.hostAliases = new ArrayList<HostAliasBuilder>(); for (HostAlias item : hostAliases){this.addToHostAliases(item);}} else { this.hostAliases = null;} return (A) this;
    }

    public A withHostAliases(HostAlias... hostAliases) {
        if (this.hostAliases != null) {this.hostAliases.clear();}
        if (hostAliases != null) {for (HostAlias item :hostAliases){ this.addToHostAliases(item);}} return (A) this;
    }

    public Boolean hasHostAliases() {
        return hostAliases != null && !hostAliases.isEmpty();
    }

    public PodSpecFluent.HostAliasesNested<A> addNewHostAlias() {
        return new HostAliasesNestedImpl();
    }

    public PodSpecFluent.HostAliasesNested<A> addNewHostAliasLike(HostAlias item) {
        return new HostAliasesNestedImpl(-1, item);
    }

    public PodSpecFluent.HostAliasesNested<A> setNewHostAliasLike(int index,HostAlias item) {
        return new HostAliasesNestedImpl(index, item);
    }

    public PodSpecFluent.HostAliasesNested<A> editHostAlias(int index) {
        if (hostAliases.size() <= index) throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
        return setNewHostAliasLike(index, buildHostAlias(index));
    }

    public PodSpecFluent.HostAliasesNested<A> editFirstHostAlias() {
        if (hostAliases.size() == 0) throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
        return setNewHostAliasLike(0, buildHostAlias(0));
    }

    public PodSpecFluent.HostAliasesNested<A> editLastHostAlias() {
        int index = hostAliases.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
        return setNewHostAliasLike(index, buildHostAlias(index));
    }

    public PodSpecFluent.HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        int index = -1;
        for (int i=0;i<hostAliases.size();i++) { 
        if (predicate.test(hostAliases.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching hostAliases. No match found.");
        return setNewHostAliasLike(index, buildHostAlias(index));
    }

    public Boolean isHostIPC() {
        return this.hostIPC;
    }

    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC=hostIPC; return (A) this;
    }

    public Boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    public A withNewHostIPC(String arg1) {
        return (A)withHostIPC(new Boolean(arg1));
    }

    public A withNewHostIPC(boolean arg1) {
        return (A)withHostIPC(new Boolean(arg1));
    }

    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork=hostNetwork; return (A) this;
    }

    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    public A withNewHostNetwork(String arg1) {
        return (A)withHostNetwork(new Boolean(arg1));
    }

    public A withNewHostNetwork(boolean arg1) {
        return (A)withHostNetwork(new Boolean(arg1));
    }

    public Boolean isHostPID() {
        return this.hostPID;
    }

    public A withHostPID(Boolean hostPID) {
        this.hostPID=hostPID; return (A) this;
    }

    public Boolean hasHostPID() {
        return this.hostPID != null;
    }

    public A withNewHostPID(String arg1) {
        return (A)withHostPID(new Boolean(arg1));
    }

    public A withNewHostPID(boolean arg1) {
        return (A)withHostPID(new Boolean(arg1));
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname=hostname; return (A) this;
    }

    public Boolean hasHostname() {
        return this.hostname != null;
    }

    public A withNewHostname(String arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuilder arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuffer arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A addToImagePullSecrets(int index,LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(index >= 0 ? index : _visitables.get("imagePullSecrets").size(), builder);this.imagePullSecrets.add(index >= 0 ? index : imagePullSecrets.size(), builder); return (A)this;
    }

    public A setToImagePullSecrets(int index,LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= _visitables.get("imagePullSecrets").size()) { _visitables.get("imagePullSecrets").add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder);}
        if (index < 0 || index >= imagePullSecrets.size()) { imagePullSecrets.add(builder); } else { imagePullSecrets.set(index, builder);}
         return (A)this;
    }

    public A addToImagePullSecrets(LocalObjectReference... items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A removeFromImagePullSecrets(LocalObjectReference... items) {
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
    }

    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (imagePullSecrets == null) return (A) this;
        final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
        final List visitables = _visitables.get("imagePullSecrets");
        while (each.hasNext()) {
          LocalObjectReferenceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<LocalObjectReference> getImagePullSecrets() {
        return build(imagePullSecrets);
    }

    public List<LocalObjectReference> buildImagePullSecrets() {
        return build(imagePullSecrets);
    }

    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
    }

    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);}
        if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
    }

    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets) {
        if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
        if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
    }

    public Boolean hasImagePullSecrets() {
        return imagePullSecrets != null && !imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(String name) {
        return (A)addToImagePullSecrets(new LocalObjectReference(name));
    }

    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    public PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    public PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        return setNewImagePullSecretLike(0, buildImagePullSecret(0));
    }

    public PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = imagePullSecrets.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<imagePullSecrets.size();i++) { 
        if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public A addToInitContainers(int index,Container item) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
    }

    public A setToInitContainers(int index,Container item) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
        if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
         return (A)this;
    }

    public A addToInitContainers(Container... items) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
    }

    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
    }

    public A removeFromInitContainers(Container... items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
    }

    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (initContainers == null) return (A) this;
        final Iterator<ContainerBuilder> each = initContainers.iterator();
        final List visitables = _visitables.get("initContainers");
        while (each.hasNext()) {
          ContainerBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildInitContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getInitContainers() {
        return build(initContainers);
    }

    public List<Container> buildInitContainers() {
        return build(initContainers);
    }

    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    public Container buildLastInitContainer() {
        return this.initContainers.get(initContainers.size() - 1).build();
    }

    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) { _visitables.get("initContainers").removeAll(this.initContainers);}
        if (initContainers != null) {this.initContainers = new ArrayList<ContainerBuilder>(); for (Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
    }

    public A withInitContainers(Container... initContainers) {
        if (this.initContainers != null) {this.initContainers.clear();}
        if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
    }

    public Boolean hasInitContainers() {
        return initContainers != null && !initContainers.isEmpty();
    }

    public PodSpecFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    public PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    public PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index,Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    public PodSpecFluent.InitContainersNested<A> editInitContainer(int index) {
        if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public PodSpecFluent.InitContainersNested<A> editFirstInitContainer() {
        if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        return setNewInitContainerLike(0, buildInitContainer(0));
    }

    public PodSpecFluent.InitContainersNested<A> editLastInitContainer() {
        int index = initContainers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<initContainers.size();i++) { 
        if (predicate.test(initContainers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
        return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName=nodeName; return (A) this;
    }

    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A withNewNodeName(String arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A withNewNodeName(StringBuilder arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A withNewNodeName(StringBuffer arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A addToNodeSelector(String key,String value) {
        if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if(this.nodeSelector == null) { return (A) this; }
        if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getNodeSelector() {
        return this.nodeSelector;
    }

    public A withNodeSelector(Map<String,String> nodeSelector) {
        if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap<String,String>(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public A addToOverhead(String key,Quantity value) {
        if(this.overhead == null && key != null && value != null) { this.overhead = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this.overhead.put(key, value);} return (A)this;
    }

    public A addToOverhead(Map<String,Quantity> map) {
        if(this.overhead == null && map != null) { this.overhead = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this.overhead.putAll(map);} return (A)this;
    }

    public A removeFromOverhead(String key) {
        if(this.overhead == null) { return (A) this; }
        if(key != null && this.overhead != null) {this.overhead.remove(key);} return (A)this;
    }

    public A removeFromOverhead(Map<String,Quantity> map) {
        if(this.overhead == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.overhead != null){this.overhead.remove(key);}}} return (A)this;
    }

    public Map<String,Quantity> getOverhead() {
        return this.overhead;
    }

    public A withOverhead(Map<String,Quantity> overhead) {
        if (overhead == null) { this.overhead =  null;} else {this.overhead = new LinkedHashMap<String,Quantity>(overhead);} return (A) this;
    }

    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy=preemptionPolicy; return (A) this;
    }

    public Boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    public A withNewPreemptionPolicy(String arg1) {
        return (A)withPreemptionPolicy(new String(arg1));
    }

    public A withNewPreemptionPolicy(StringBuilder arg1) {
        return (A)withPreemptionPolicy(new String(arg1));
    }

    public A withNewPreemptionPolicy(StringBuffer arg1) {
        return (A)withPreemptionPolicy(new String(arg1));
    }

    public Integer getPriority() {
        return this.priority;
    }

    public A withPriority(Integer priority) {
        this.priority=priority; return (A) this;
    }

    public Boolean hasPriority() {
        return this.priority != null;
    }

    public A withNewPriority(String arg1) {
        return (A)withPriority(new Integer(arg1));
    }

    public A withNewPriority(int arg1) {
        return (A)withPriority(new Integer(arg1));
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName=priorityClassName; return (A) this;
    }

    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public A withNewPriorityClassName(String arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A withNewPriorityClassName(StringBuilder arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A withNewPriorityClassName(StringBuffer arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A addToReadinessGates(int index,PodReadinessGate item) {
        if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGateBuilder>();}
        PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);_visitables.get("readinessGates").add(index >= 0 ? index : _visitables.get("readinessGates").size(), builder);this.readinessGates.add(index >= 0 ? index : readinessGates.size(), builder); return (A)this;
    }

    public A setToReadinessGates(int index,PodReadinessGate item) {
        if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGateBuilder>();}
        PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
        if (index < 0 || index >= _visitables.get("readinessGates").size()) { _visitables.get("readinessGates").add(builder); } else { _visitables.get("readinessGates").set(index, builder);}
        if (index < 0 || index >= readinessGates.size()) { readinessGates.add(builder); } else { readinessGates.set(index, builder);}
         return (A)this;
    }

    public A addToReadinessGates(PodReadinessGate... items) {
        if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGateBuilder>();}
        for (PodReadinessGate item : items) {PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);_visitables.get("readinessGates").add(builder);this.readinessGates.add(builder);} return (A)this;
    }

    public A addAllToReadinessGates(Collection<PodReadinessGate> items) {
        if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGateBuilder>();}
        for (PodReadinessGate item : items) {PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);_visitables.get("readinessGates").add(builder);this.readinessGates.add(builder);} return (A)this;
    }

    public A removeFromReadinessGates(PodReadinessGate... items) {
        for (PodReadinessGate item : items) {PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);_visitables.get("readinessGates").remove(builder);if (this.readinessGates != null) {this.readinessGates.remove(builder);}} return (A)this;
    }

    public A removeAllFromReadinessGates(Collection<PodReadinessGate> items) {
        for (PodReadinessGate item : items) {PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);_visitables.get("readinessGates").remove(builder);if (this.readinessGates != null) {this.readinessGates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromReadinessGates(Predicate<PodReadinessGateBuilder> predicate) {
        if (readinessGates == null) return (A) this;
        final Iterator<PodReadinessGateBuilder> each = readinessGates.iterator();
        final List visitables = _visitables.get("readinessGates");
        while (each.hasNext()) {
          PodReadinessGateBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildReadinessGates instead.
 * @return The buildable object.
 */
@Deprecated public List<PodReadinessGate> getReadinessGates() {
        return build(readinessGates);
    }

    public List<PodReadinessGate> buildReadinessGates() {
        return build(readinessGates);
    }

    public PodReadinessGate buildReadinessGate(int index) {
        return this.readinessGates.get(index).build();
    }

    public PodReadinessGate buildFirstReadinessGate() {
        return this.readinessGates.get(0).build();
    }

    public PodReadinessGate buildLastReadinessGate() {
        return this.readinessGates.get(readinessGates.size() - 1).build();
    }

    public PodReadinessGate buildMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        for (PodReadinessGateBuilder item: readinessGates) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        for (PodReadinessGateBuilder item: readinessGates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withReadinessGates(List<PodReadinessGate> readinessGates) {
        if (this.readinessGates != null) { _visitables.get("readinessGates").removeAll(this.readinessGates);}
        if (readinessGates != null) {this.readinessGates = new ArrayList<PodReadinessGateBuilder>(); for (PodReadinessGate item : readinessGates){this.addToReadinessGates(item);}} else { this.readinessGates = null;} return (A) this;
    }

    public A withReadinessGates(PodReadinessGate... readinessGates) {
        if (this.readinessGates != null) {this.readinessGates.clear();}
        if (readinessGates != null) {for (PodReadinessGate item :readinessGates){ this.addToReadinessGates(item);}} return (A) this;
    }

    public Boolean hasReadinessGates() {
        return readinessGates != null && !readinessGates.isEmpty();
    }

    public A addNewReadinessGate(String conditionType) {
        return (A)addToReadinessGates(new PodReadinessGate(conditionType));
    }

    public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGate() {
        return new ReadinessGatesNestedImpl();
    }

    public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGateLike(PodReadinessGate item) {
        return new ReadinessGatesNestedImpl(-1, item);
    }

    public PodSpecFluent.ReadinessGatesNested<A> setNewReadinessGateLike(int index,PodReadinessGate item) {
        return new ReadinessGatesNestedImpl(index, item);
    }

    public PodSpecFluent.ReadinessGatesNested<A> editReadinessGate(int index) {
        if (readinessGates.size() <= index) throw new RuntimeException("Can't edit readinessGates. Index exceeds size.");
        return setNewReadinessGateLike(index, buildReadinessGate(index));
    }

    public PodSpecFluent.ReadinessGatesNested<A> editFirstReadinessGate() {
        if (readinessGates.size() == 0) throw new RuntimeException("Can't edit first readinessGates. The list is empty.");
        return setNewReadinessGateLike(0, buildReadinessGate(0));
    }

    public PodSpecFluent.ReadinessGatesNested<A> editLastReadinessGate() {
        int index = readinessGates.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last readinessGates. The list is empty.");
        return setNewReadinessGateLike(index, buildReadinessGate(index));
    }

    public PodSpecFluent.ReadinessGatesNested<A> editMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        int index = -1;
        for (int i=0;i<readinessGates.size();i++) { 
        if (predicate.test(readinessGates.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching readinessGates. No match found.");
        return setNewReadinessGateLike(index, buildReadinessGate(index));
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy=restartPolicy; return (A) this;
    }

    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public A withNewRestartPolicy(String arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public A withNewRestartPolicy(StringBuilder arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public A withNewRestartPolicy(StringBuffer arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName=runtimeClassName; return (A) this;
    }

    public Boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    public A withNewRuntimeClassName(String arg1) {
        return (A)withRuntimeClassName(new String(arg1));
    }

    public A withNewRuntimeClassName(StringBuilder arg1) {
        return (A)withRuntimeClassName(new String(arg1));
    }

    public A withNewRuntimeClassName(StringBuffer arg1) {
        return (A)withRuntimeClassName(new String(arg1));
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public A withSchedulerName(String schedulerName) {
        this.schedulerName=schedulerName; return (A) this;
    }

    public Boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    public A withNewSchedulerName(String arg1) {
        return (A)withSchedulerName(new String(arg1));
    }

    public A withNewSchedulerName(StringBuilder arg1) {
        return (A)withSchedulerName(new String(arg1));
    }

    public A withNewSchedulerName(StringBuffer arg1) {
        return (A)withSchedulerName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecurityContext instead.
 * @return The buildable object.
 */
@Deprecated public PodSecurityContext getSecurityContext() {
        return this.securityContext!=null?this.securityContext.build():null;
    }

    public PodSecurityContext buildSecurityContext() {
        return this.securityContext!=null?this.securityContext.build():null;
    }

    public A withSecurityContext(PodSecurityContext securityContext) {
        _visitables.get("securityContext").remove(this.securityContext);
        if (securityContext!=null){ this.securityContext= new PodSecurityContextBuilder(securityContext); _visitables.get("securityContext").add(this.securityContext);} return (A) this;
    }

    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNestedImpl();
    }

    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item) {
        return new SecurityContextNestedImpl(item);
    }

    public PodSpecFluent.SecurityContextNested<A> editSecurityContext() {
        return withNewSecurityContextLike(getSecurityContext());
    }

    public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext() {
        return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): new PodSecurityContextBuilder().build());
    }

    public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(PodSecurityContext item) {
        return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): item);
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount=serviceAccount; return (A) this;
    }

    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public A withNewServiceAccount(String arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuilder arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuffer arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public Boolean isSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN;
    }

    public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN) {
        this.setHostnameAsFQDN=setHostnameAsFQDN; return (A) this;
    }

    public Boolean hasSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN != null;
    }

    public A withNewSetHostnameAsFQDN(String arg1) {
        return (A)withSetHostnameAsFQDN(new Boolean(arg1));
    }

    public A withNewSetHostnameAsFQDN(boolean arg1) {
        return (A)withSetHostnameAsFQDN(new Boolean(arg1));
    }

    public Boolean isShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    public A withShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace=shareProcessNamespace; return (A) this;
    }

    public Boolean hasShareProcessNamespace() {
        return this.shareProcessNamespace != null;
    }

    public A withNewShareProcessNamespace(String arg1) {
        return (A)withShareProcessNamespace(new Boolean(arg1));
    }

    public A withNewShareProcessNamespace(boolean arg1) {
        return (A)withShareProcessNamespace(new Boolean(arg1));
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public A withSubdomain(String subdomain) {
        this.subdomain=subdomain; return (A) this;
    }

    public Boolean hasSubdomain() {
        return this.subdomain != null;
    }

    public A withNewSubdomain(String arg1) {
        return (A)withSubdomain(new String(arg1));
    }

    public A withNewSubdomain(StringBuilder arg1) {
        return (A)withSubdomain(new String(arg1));
    }

    public A withNewSubdomain(StringBuffer arg1) {
        return (A)withSubdomain(new String(arg1));
    }

    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
    }

    public Boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    public A withNewTerminationGracePeriodSeconds(String arg1) {
        return (A)withTerminationGracePeriodSeconds(new Long(arg1));
    }

    public A withNewTerminationGracePeriodSeconds(long arg1) {
        return (A)withTerminationGracePeriodSeconds(new Long(arg1));
    }

    public A addToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
        TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").add(index >= 0 ? index : _visitables.get("tolerations").size(), builder);this.tolerations.add(index >= 0 ? index : tolerations.size(), builder); return (A)this;
    }

    public A setToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
        TolerationBuilder builder = new TolerationBuilder(item);
        if (index < 0 || index >= _visitables.get("tolerations").size()) { _visitables.get("tolerations").add(builder); } else { _visitables.get("tolerations").set(index, builder);}
        if (index < 0 || index >= tolerations.size()) { tolerations.add(builder); } else { tolerations.set(index, builder);}
         return (A)this;
    }

    public A addToTolerations(Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
        for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").add(builder);this.tolerations.add(builder);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
        for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").add(builder);this.tolerations.add(builder);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items) {
        for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").remove(builder);if (this.tolerations != null) {this.tolerations.remove(builder);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").remove(builder);if (this.tolerations != null) {this.tolerations.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTolerations(Predicate<TolerationBuilder> predicate) {
        if (tolerations == null) return (A) this;
        final Iterator<TolerationBuilder> each = tolerations.iterator();
        final List visitables = _visitables.get("tolerations");
        while (each.hasNext()) {
          TolerationBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTolerations instead.
 * @return The buildable object.
 */
@Deprecated public List<Toleration> getTolerations() {
        return build(tolerations);
    }

    public List<Toleration> buildTolerations() {
        return build(tolerations);
    }

    public Toleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    public Toleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    public Toleration buildLastToleration() {
        return this.tolerations.get(tolerations.size() - 1).build();
    }

    public Toleration buildMatchingToleration(Predicate<TolerationBuilder> predicate) {
        for (TolerationBuilder item: tolerations) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingToleration(Predicate<TolerationBuilder> predicate) {
        for (TolerationBuilder item: tolerations) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new ArrayList<TolerationBuilder>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public PodSpecFluent.TolerationsNested<A> addNewToleration() {
        return new TolerationsNestedImpl();
    }

    public PodSpecFluent.TolerationsNested<A> addNewTolerationLike(Toleration item) {
        return new TolerationsNestedImpl(-1, item);
    }

    public PodSpecFluent.TolerationsNested<A> setNewTolerationLike(int index,Toleration item) {
        return new TolerationsNestedImpl(index, item);
    }

    public PodSpecFluent.TolerationsNested<A> editToleration(int index) {
        if (tolerations.size() <= index) throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        return setNewTolerationLike(index, buildToleration(index));
    }

    public PodSpecFluent.TolerationsNested<A> editFirstToleration() {
        if (tolerations.size() == 0) throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        return setNewTolerationLike(0, buildToleration(0));
    }

    public PodSpecFluent.TolerationsNested<A> editLastToleration() {
        int index = tolerations.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        return setNewTolerationLike(index, buildToleration(index));
    }

    public PodSpecFluent.TolerationsNested<A> editMatchingToleration(Predicate<TolerationBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tolerations.size();i++) { 
        if (predicate.test(tolerations.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tolerations. No match found.");
        return setNewTolerationLike(index, buildToleration(index));
    }

    public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraintBuilder>();}
        TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);_visitables.get("topologySpreadConstraints").add(index >= 0 ? index : _visitables.get("topologySpreadConstraints").size(), builder);this.topologySpreadConstraints.add(index >= 0 ? index : topologySpreadConstraints.size(), builder); return (A)this;
    }

    public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraintBuilder>();}
        TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
        if (index < 0 || index >= _visitables.get("topologySpreadConstraints").size()) { _visitables.get("topologySpreadConstraints").add(builder); } else { _visitables.get("topologySpreadConstraints").set(index, builder);}
        if (index < 0 || index >= topologySpreadConstraints.size()) { topologySpreadConstraints.add(builder); } else { topologySpreadConstraints.set(index, builder);}
         return (A)this;
    }

    public A addToTopologySpreadConstraints(TopologySpreadConstraint... items) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraintBuilder>();}
        for (TopologySpreadConstraint item : items) {TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);_visitables.get("topologySpreadConstraints").add(builder);this.topologySpreadConstraints.add(builder);} return (A)this;
    }

    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraintBuilder>();}
        for (TopologySpreadConstraint item : items) {TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);_visitables.get("topologySpreadConstraints").add(builder);this.topologySpreadConstraints.add(builder);} return (A)this;
    }

    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint... items) {
        for (TopologySpreadConstraint item : items) {TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);_visitables.get("topologySpreadConstraints").remove(builder);if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.remove(builder);}} return (A)this;
    }

    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        for (TopologySpreadConstraint item : items) {TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);_visitables.get("topologySpreadConstraints").remove(builder);if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTopologySpreadConstraints(Predicate<TopologySpreadConstraintBuilder> predicate) {
        if (topologySpreadConstraints == null) return (A) this;
        final Iterator<TopologySpreadConstraintBuilder> each = topologySpreadConstraints.iterator();
        final List visitables = _visitables.get("topologySpreadConstraints");
        while (each.hasNext()) {
          TopologySpreadConstraintBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTopologySpreadConstraints instead.
 * @return The buildable object.
 */
@Deprecated public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return build(topologySpreadConstraints);
    }

    public List<TopologySpreadConstraint> buildTopologySpreadConstraints() {
        return build(topologySpreadConstraints);
    }

    public TopologySpreadConstraint buildTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index).build();
    }

    public TopologySpreadConstraint buildFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0).build();
    }

    public TopologySpreadConstraint buildLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1).build();
    }

    public TopologySpreadConstraint buildMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
        for (TopologySpreadConstraintBuilder item: topologySpreadConstraints) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
        for (TopologySpreadConstraintBuilder item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) { _visitables.get("topologySpreadConstraints").removeAll(this.topologySpreadConstraints);}
        if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraintBuilder>(); for (TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
    }

    public A withTopologySpreadConstraints(TopologySpreadConstraint... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear();}
        if (topologySpreadConstraints != null) {for (TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
    }

    public Boolean hasTopologySpreadConstraints() {
        return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
    }

    public PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraint() {
        return new TopologySpreadConstraintsNestedImpl();
    }

    public PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraintLike(TopologySpreadConstraint item) {
        return new TopologySpreadConstraintsNestedImpl(-1, item);
    }

    public PodSpecFluent.TopologySpreadConstraintsNested<A> setNewTopologySpreadConstraintLike(int index,TopologySpreadConstraint item) {
        return new TopologySpreadConstraintsNestedImpl(index, item);
    }

    public PodSpecFluent.TopologySpreadConstraintsNested<A> editTopologySpreadConstraint(int index) {
        if (topologySpreadConstraints.size() <= index) throw new RuntimeException("Can't edit topologySpreadConstraints. Index exceeds size.");
        return setNewTopologySpreadConstraintLike(index, buildTopologySpreadConstraint(index));
    }

    public PodSpecFluent.TopologySpreadConstraintsNested<A> editFirstTopologySpreadConstraint() {
        if (topologySpreadConstraints.size() == 0) throw new RuntimeException("Can't edit first topologySpreadConstraints. The list is empty.");
        return setNewTopologySpreadConstraintLike(0, buildTopologySpreadConstraint(0));
    }

    public PodSpecFluent.TopologySpreadConstraintsNested<A> editLastTopologySpreadConstraint() {
        int index = topologySpreadConstraints.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last topologySpreadConstraints. The list is empty.");
        return setNewTopologySpreadConstraintLike(index, buildTopologySpreadConstraint(index));
    }

    public PodSpecFluent.TopologySpreadConstraintsNested<A> editMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
        int index = -1;
        for (int i=0;i<topologySpreadConstraints.size();i++) { 
        if (predicate.test(topologySpreadConstraints.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching topologySpreadConstraints. No match found.");
        return setNewTopologySpreadConstraintLike(index, buildTopologySpreadConstraint(index));
    }

    public A addToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
        if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
         return (A)this;
    }

    public A addToVolumes(Volume... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(Volume... items) {
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (volumes == null) return (A) this;
        final Iterator<VolumeBuilder> each = volumes.iterator();
        final List visitables = _visitables.get("volumes");
        while (each.hasNext()) {
          VolumeBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<Volume> getVolumes() {
        return build(volumes);
    }

    public List<Volume> buildVolumes() {
        return build(volumes);
    }

    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public Volume buildLastVolume() {
        return this.volumes.get(volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new ArrayList<VolumeBuilder>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(Volume... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public PodSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    public PodSpecFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    public PodSpecFluent.VolumesNested<A> editVolume(int index) {
        if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public PodSpecFluent.VolumesNested<A> editFirstVolume() {
        if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
        return setNewVolumeLike(0, buildVolume(0));
    }

    public PodSpecFluent.VolumesNested<A> editLastVolume() {
        int index = volumes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public PodSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumes.size();i++) { 
        if (predicate.test(volumes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodSpecFluentImpl that = (PodSpecFluentImpl) o;
        if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (automountServiceAccountToken != null ? !automountServiceAccountToken.equals(that.automountServiceAccountToken) :that.automountServiceAccountToken != null) return false;
        if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
        if (dnsConfig != null ? !dnsConfig.equals(that.dnsConfig) :that.dnsConfig != null) return false;
        if (dnsPolicy != null ? !dnsPolicy.equals(that.dnsPolicy) :that.dnsPolicy != null) return false;
        if (enableServiceLinks != null ? !enableServiceLinks.equals(that.enableServiceLinks) :that.enableServiceLinks != null) return false;
        if (ephemeralContainers != null ? !ephemeralContainers.equals(that.ephemeralContainers) :that.ephemeralContainers != null) return false;
        if (hostAliases != null ? !hostAliases.equals(that.hostAliases) :that.hostAliases != null) return false;
        if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
        if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
        if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
        if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
        if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
        if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
        if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
        if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
        if (overhead != null ? !overhead.equals(that.overhead) :that.overhead != null) return false;
        if (preemptionPolicy != null ? !preemptionPolicy.equals(that.preemptionPolicy) :that.preemptionPolicy != null) return false;
        if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
        if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
        if (readinessGates != null ? !readinessGates.equals(that.readinessGates) :that.readinessGates != null) return false;
        if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
        if (runtimeClassName != null ? !runtimeClassName.equals(that.runtimeClassName) :that.runtimeClassName != null) return false;
        if (schedulerName != null ? !schedulerName.equals(that.schedulerName) :that.schedulerName != null) return false;
        if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (setHostnameAsFQDN != null ? !setHostnameAsFQDN.equals(that.setHostnameAsFQDN) :that.setHostnameAsFQDN != null) return false;
        if (shareProcessNamespace != null ? !shareProcessNamespace.equals(that.shareProcessNamespace) :that.shareProcessNamespace != null) return false;
        if (subdomain != null ? !subdomain.equals(that.subdomain) :that.subdomain != null) return false;
        if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        if (topologySpreadConstraints != null ? !topologySpreadConstraints.equals(that.topologySpreadConstraints) :that.topologySpreadConstraints != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(activeDeadlineSeconds,  affinity,  automountServiceAccountToken,  containers,  dnsConfig,  dnsPolicy,  enableServiceLinks,  ephemeralContainers,  hostAliases,  hostIPC,  hostNetwork,  hostPID,  hostname,  imagePullSecrets,  initContainers,  nodeName,  nodeSelector,  overhead,  preemptionPolicy,  priority,  priorityClassName,  readinessGates,  restartPolicy,  runtimeClassName,  schedulerName,  securityContext,  serviceAccount,  serviceAccountName,  setHostnameAsFQDN,  shareProcessNamespace,  subdomain,  terminationGracePeriodSeconds,  tolerations,  topologySpreadConstraints,  volumes,  super.hashCode());
    }

    public class AffinityNestedImpl<N> extends AffinityFluentImpl<PodSpecFluent.AffinityNested<N>> implements PodSpecFluent.AffinityNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AffinityBuilder builder;

            AffinityNestedImpl(Affinity item) {
                this.builder = new AffinityBuilder(this, item);
                        
            }

            AffinityNestedImpl() {
                this.builder = new AffinityBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.withAffinity(builder.build());
            }

            public N endAffinity() {
                return and();
            }
    }


    public class ContainersNestedImpl<N> extends ContainerFluentImpl<PodSpecFluent.ContainersNested<N>> implements PodSpecFluent.ContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

            ContainersNestedImpl(int index,Container item) {
                this.index = index;
                this.builder = new ContainerBuilder(this, item);
                        
            }

            ContainersNestedImpl() {
                this.index = -1;
                this.builder = new ContainerBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.setToContainers(index,builder.build());
            }

            public N endContainer() {
                return and();
            }
    }


    public class DnsConfigNestedImpl<N> extends PodDNSConfigFluentImpl<PodSpecFluent.DnsConfigNested<N>> implements PodSpecFluent.DnsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodDNSConfigBuilder builder;

            DnsConfigNestedImpl(PodDNSConfig item) {
                this.builder = new PodDNSConfigBuilder(this, item);
                        
            }

            DnsConfigNestedImpl() {
                this.builder = new PodDNSConfigBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.withDnsConfig(builder.build());
            }

            public N endDnsConfig() {
                return and();
            }
    }


    public class EphemeralContainersNestedImpl<N> extends EphemeralContainerFluentImpl<PodSpecFluent.EphemeralContainersNested<N>> implements PodSpecFluent.EphemeralContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EphemeralContainerBuilder builder;
        private final int index;

            EphemeralContainersNestedImpl(int index,EphemeralContainer item) {
                this.index = index;
                this.builder = new EphemeralContainerBuilder(this, item);
                        
            }

            EphemeralContainersNestedImpl() {
                this.index = -1;
                this.builder = new EphemeralContainerBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.setToEphemeralContainers(index,builder.build());
            }

            public N endEphemeralContainer() {
                return and();
            }
    }


    public class HostAliasesNestedImpl<N> extends HostAliasFluentImpl<PodSpecFluent.HostAliasesNested<N>> implements PodSpecFluent.HostAliasesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HostAliasBuilder builder;
        private final int index;

            HostAliasesNestedImpl(int index,HostAlias item) {
                this.index = index;
                this.builder = new HostAliasBuilder(this, item);
                        
            }

            HostAliasesNestedImpl() {
                this.index = -1;
                this.builder = new HostAliasBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.setToHostAliases(index,builder.build());
            }

            public N endHostAlias() {
                return and();
            }
    }


    public class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<PodSpecFluent.ImagePullSecretsNested<N>> implements PodSpecFluent.ImagePullSecretsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LocalObjectReferenceBuilder builder;
        private final int index;

            ImagePullSecretsNestedImpl(int index,LocalObjectReference item) {
                this.index = index;
                this.builder = new LocalObjectReferenceBuilder(this, item);
                        
            }

            ImagePullSecretsNestedImpl() {
                this.index = -1;
                this.builder = new LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.setToImagePullSecrets(index,builder.build());
            }

            public N endImagePullSecret() {
                return and();
            }
    }


    public class InitContainersNestedImpl<N> extends ContainerFluentImpl<PodSpecFluent.InitContainersNested<N>> implements PodSpecFluent.InitContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

            InitContainersNestedImpl(int index,Container item) {
                this.index = index;
                this.builder = new ContainerBuilder(this, item);
                        
            }

            InitContainersNestedImpl() {
                this.index = -1;
                this.builder = new ContainerBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.setToInitContainers(index,builder.build());
            }

            public N endInitContainer() {
                return and();
            }
    }


    public class ReadinessGatesNestedImpl<N> extends PodReadinessGateFluentImpl<PodSpecFluent.ReadinessGatesNested<N>> implements PodSpecFluent.ReadinessGatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodReadinessGateBuilder builder;
        private final int index;

            ReadinessGatesNestedImpl(int index,PodReadinessGate item) {
                this.index = index;
                this.builder = new PodReadinessGateBuilder(this, item);
                        
            }

            ReadinessGatesNestedImpl() {
                this.index = -1;
                this.builder = new PodReadinessGateBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.setToReadinessGates(index,builder.build());
            }

            public N endReadinessGate() {
                return and();
            }
    }


    public class SecurityContextNestedImpl<N> extends PodSecurityContextFluentImpl<PodSpecFluent.SecurityContextNested<N>> implements PodSpecFluent.SecurityContextNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodSecurityContextBuilder builder;

            SecurityContextNestedImpl(PodSecurityContext item) {
                this.builder = new PodSecurityContextBuilder(this, item);
                        
            }

            SecurityContextNestedImpl() {
                this.builder = new PodSecurityContextBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.withSecurityContext(builder.build());
            }

            public N endSecurityContext() {
                return and();
            }
    }


    public class TolerationsNestedImpl<N> extends TolerationFluentImpl<PodSpecFluent.TolerationsNested<N>> implements PodSpecFluent.TolerationsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TolerationBuilder builder;
        private final int index;

            TolerationsNestedImpl(int index,Toleration item) {
                this.index = index;
                this.builder = new TolerationBuilder(this, item);
                        
            }

            TolerationsNestedImpl() {
                this.index = -1;
                this.builder = new TolerationBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.setToTolerations(index,builder.build());
            }

            public N endToleration() {
                return and();
            }
    }


    public class TopologySpreadConstraintsNestedImpl<N> extends TopologySpreadConstraintFluentImpl<PodSpecFluent.TopologySpreadConstraintsNested<N>> implements PodSpecFluent.TopologySpreadConstraintsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TopologySpreadConstraintBuilder builder;
        private final int index;

            TopologySpreadConstraintsNestedImpl(int index,TopologySpreadConstraint item) {
                this.index = index;
                this.builder = new TopologySpreadConstraintBuilder(this, item);
                        
            }

            TopologySpreadConstraintsNestedImpl() {
                this.index = -1;
                this.builder = new TopologySpreadConstraintBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.setToTopologySpreadConstraints(index,builder.build());
            }

            public N endTopologySpreadConstraint() {
                return and();
            }
    }


    public class VolumesNestedImpl<N> extends VolumeFluentImpl<PodSpecFluent.VolumesNested<N>> implements PodSpecFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeBuilder builder;
        private final int index;

            VolumesNestedImpl(int index,Volume item) {
                this.index = index;
                this.builder = new VolumeBuilder(this, item);
                        
            }

            VolumesNestedImpl() {
                this.index = -1;
                this.builder = new VolumeBuilder(this);
                        
            }

            public N and() {
                return (N) PodSpecFluentImpl.this.setToVolumes(index,builder.build());
            }

            public N endVolume() {
                return and();
            }
    }


}
