package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReplicationControllerStatusBuilder extends ReplicationControllerStatusFluentImpl<ReplicationControllerStatusBuilder> implements VisitableBuilder<ReplicationControllerStatus,ReplicationControllerStatusBuilder> {

    ReplicationControllerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicationControllerStatusBuilder() {
        this(true);
    }

    public ReplicationControllerStatusBuilder(Boolean validationEnabled) {
        this(new ReplicationControllerStatus(), validationEnabled);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ReplicationControllerStatus(), validationEnabled);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent,ReplicationControllerStatus instance) {
        this(fluent, instance, true);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent,ReplicationControllerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withReplicas(instance.getReplicas()); 
        this.validationEnabled = validationEnabled; 
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance) {
        this(instance,true);
    }

    public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAvailableReplicas(instance.getAvailableReplicas()); 
        this.withConditions(instance.getConditions()); 
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withReplicas(instance.getReplicas()); 
        this.validationEnabled = validationEnabled; 
    }

    public ReplicationControllerStatus build() {
        ReplicationControllerStatus buildable = new ReplicationControllerStatus(fluent.getAvailableReplicas(),fluent.getConditions(),fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ReplicationControllerStatusBuilder that = (ReplicationControllerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
