package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodeAffinityBuilder extends NodeAffinityFluentImpl<NodeAffinityBuilder> implements VisitableBuilder<NodeAffinity,NodeAffinityBuilder> {

    NodeAffinityFluent<?> fluent;
    Boolean validationEnabled;

    public NodeAffinityBuilder() {
        this(true);
    }

    public NodeAffinityBuilder(Boolean validationEnabled) {
        this(new NodeAffinity(), validationEnabled);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent) {
        this(fluent, true);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NodeAffinity(), validationEnabled);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent,NodeAffinity instance) {
        this(fluent, instance, true);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent,NodeAffinity instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution()); 
        fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodeAffinityBuilder(NodeAffinity instance) {
        this(instance,true);
    }

    public NodeAffinityBuilder(NodeAffinity instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution()); 
        this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodeAffinity build() {
        NodeAffinity buildable = new NodeAffinity(fluent.getPreferredDuringSchedulingIgnoredDuringExecution(),fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodeAffinityBuilder that = (NodeAffinityBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
