package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ListMetaFluentImpl<A extends ListMetaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ListMetaFluent<A> {

    private String _continue;
    private Long remainingItemCount;
    private String resourceVersion;
    private String selfLink;

    public ListMetaFluentImpl() {
    }

    public ListMetaFluentImpl(ListMeta instance) {
        this.withContinue(instance.getContinue()); 
        this.withRemainingItemCount(instance.getRemainingItemCount()); 
        this.withResourceVersion(instance.getResourceVersion()); 
        this.withSelfLink(instance.getSelfLink()); 
    }

    public String getContinue() {
        return this._continue;
    }

    public A withContinue(String _continue) {
        this._continue=_continue; return (A) this;
    }

    public Boolean hasContinue() {
        return this._continue != null;
    }

    public A withNewContinue(String arg1) {
        return (A)withContinue(new String(arg1));
    }

    public A withNewContinue(StringBuilder arg1) {
        return (A)withContinue(new String(arg1));
    }

    public A withNewContinue(StringBuffer arg1) {
        return (A)withContinue(new String(arg1));
    }

    public Long getRemainingItemCount() {
        return this.remainingItemCount;
    }

    public A withRemainingItemCount(Long remainingItemCount) {
        this.remainingItemCount=remainingItemCount; return (A) this;
    }

    public Boolean hasRemainingItemCount() {
        return this.remainingItemCount != null;
    }

    public A withNewRemainingItemCount(String arg1) {
        return (A)withRemainingItemCount(new Long(arg1));
    }

    public A withNewRemainingItemCount(long arg1) {
        return (A)withRemainingItemCount(new Long(arg1));
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion=resourceVersion; return (A) this;
    }

    public Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    public A withNewResourceVersion(String arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuilder arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public A withNewResourceVersion(StringBuffer arg1) {
        return (A)withResourceVersion(new String(arg1));
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public A withSelfLink(String selfLink) {
        this.selfLink=selfLink; return (A) this;
    }

    public Boolean hasSelfLink() {
        return this.selfLink != null;
    }

    public A withNewSelfLink(String arg1) {
        return (A)withSelfLink(new String(arg1));
    }

    public A withNewSelfLink(StringBuilder arg1) {
        return (A)withSelfLink(new String(arg1));
    }

    public A withNewSelfLink(StringBuffer arg1) {
        return (A)withSelfLink(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ListMetaFluentImpl that = (ListMetaFluentImpl) o;
        if (_continue != null ? !_continue.equals(that._continue) :that._continue != null) return false;
        if (remainingItemCount != null ? !remainingItemCount.equals(that.remainingItemCount) :that.remainingItemCount != null) return false;
        if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
        if (selfLink != null ? !selfLink.equals(that.selfLink) :that.selfLink != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(_continue,  remainingItemCount,  resourceVersion,  selfLink,  super.hashCode());
    }

}
