package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface APIServiceSpecFluent<A extends APIServiceSpecFluent<A>> extends Fluent<A> {


    public String getCaBundle();
    public A withCaBundle(String caBundle);
    public Boolean hasCaBundle();
    public A withNewCaBundle(String arg1);
    public A withNewCaBundle(StringBuilder arg1);
    public A withNewCaBundle(StringBuffer arg1);
    public String getGroup();
    public A withGroup(String group);
    public Boolean hasGroup();
    public A withNewGroup(String arg1);
    public A withNewGroup(StringBuilder arg1);
    public A withNewGroup(StringBuffer arg1);
    public Integer getGroupPriorityMinimum();
    public A withGroupPriorityMinimum(Integer groupPriorityMinimum);
    public Boolean hasGroupPriorityMinimum();
    public A withNewGroupPriorityMinimum(String arg1);
    public A withNewGroupPriorityMinimum(int arg1);
    public Boolean isInsecureSkipTLSVerify();
    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify);
    public Boolean hasInsecureSkipTLSVerify();
    public A withNewInsecureSkipTLSVerify(String arg1);
    public A withNewInsecureSkipTLSVerify(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildService instead.
 * @return The buildable object.
 */
@Deprecated public ServiceReference getService();
    public ServiceReference buildService();
    public A withService(ServiceReference service);
    public Boolean hasService();
    public A withNewService(String name,String namespace,Integer port);
    public APIServiceSpecFluent.ServiceNested<A> withNewService();
    public APIServiceSpecFluent.ServiceNested<A> withNewServiceLike(ServiceReference item);
    public APIServiceSpecFluent.ServiceNested<A> editService();
    public APIServiceSpecFluent.ServiceNested<A> editOrNewService();
    public APIServiceSpecFluent.ServiceNested<A> editOrNewServiceLike(ServiceReference item);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public Integer getVersionPriority();
    public A withVersionPriority(Integer versionPriority);
    public Boolean hasVersionPriority();
    public A withNewVersionPriority(String arg1);
    public A withNewVersionPriority(int arg1);
    public interface ServiceNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceReferenceFluent<APIServiceSpecFluent.ServiceNested<N>> {

            public N and();
            public N endService();    }


}
