package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PersistentVolumeBuilder extends io.fabric8.kubernetes.api.model.PersistentVolumeFluentImpl<io.fabric8.kubernetes.api.model.PersistentVolumeBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.PersistentVolume,io.fabric8.kubernetes.api.model.PersistentVolumeBuilder>{
  public PersistentVolumeBuilder() {
    this(false);
  }
  public PersistentVolumeBuilder(java.lang.Boolean validationEnabled) {
    this(new PersistentVolume(), validationEnabled);
  }
  public PersistentVolumeBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PersistentVolume(), validationEnabled);
  }
  public PersistentVolumeBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolume instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolume instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeBuilder(io.fabric8.kubernetes.api.model.PersistentVolume instance) {
    this(instance,false);
  }
  public PersistentVolumeBuilder(io.fabric8.kubernetes.api.model.PersistentVolume instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PersistentVolumeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PersistentVolume build() {
    PersistentVolume buildable = new PersistentVolume(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PersistentVolumeBuilder that = (PersistentVolumeBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}