package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class APIGroupFluentImpl<A extends io.fabric8.kubernetes.api.model.APIGroupFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.APIGroupFluent<A>{
  public APIGroupFluentImpl() {
  }
  public APIGroupFluentImpl(io.fabric8.kubernetes.api.model.APIGroup instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withPreferredVersion(instance.getPreferredVersion()); 
    this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs()); 
    this.withVersions(instance.getVersions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private java.lang.String kind;
  private java.lang.String name;
  private io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder preferredVersion;
  private java.util.List<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> serverAddressByClientCIDRs =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder>();
  private java.util.List<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> versions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * Method is deprecated. use withName instead.
   */
  @java.lang.Deprecated
  public A withNewName(java.lang.String arg0) {
    return (A)withName(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildPreferredVersion instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery getPreferredVersion() {
    return this.preferredVersion!=null?this.preferredVersion.build():null;
  }
  public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery buildPreferredVersion() {
    return this.preferredVersion!=null?this.preferredVersion.build():null;
  }
  public A withPreferredVersion(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery preferredVersion) {
    _visitables.get("preferredVersion").remove(this.preferredVersion);
    if (preferredVersion!=null){ this.preferredVersion= new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(preferredVersion); _visitables.get("preferredVersion").add(this.preferredVersion);} return (A) this;
  }
  public java.lang.Boolean hasPreferredVersion() {
    return this.preferredVersion != null;
  }
  public A withNewPreferredVersion(java.lang.String groupVersion,java.lang.String version) {
    return (A)withPreferredVersion(new GroupVersionForDiscovery(groupVersion, version));
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersion() {
    return new io.fabric8.kubernetes.api.model.APIGroupFluentImpl.PreferredVersionNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersionLike(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item) {
    return new io.fabric8.kubernetes.api.model.APIGroupFluentImpl.PreferredVersionNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> editPreferredVersion() {
    return withNewPreferredVersionLike(getPreferredVersion());
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersion() {
    return withNewPreferredVersionLike(getPreferredVersion() != null ? getPreferredVersion(): new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersionLike(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item) {
    return withNewPreferredVersionLike(getPreferredVersion() != null ? getPreferredVersion(): item);
  }
  public A addToServerAddressByClientCIDRs(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item) {
    if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder>();}
    io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder builder = new io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").add(index >= 0 ? index : _visitables.get("serverAddressByClientCIDRs").size(), builder);this.serverAddressByClientCIDRs.add(index >= 0 ? index : serverAddressByClientCIDRs.size(), builder); return (A)this;
  }
  public A setToServerAddressByClientCIDRs(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item) {
    if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder>();}
    io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder builder = new io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder(item);
    if (index < 0 || index >= _visitables.get("serverAddressByClientCIDRs").size()) { _visitables.get("serverAddressByClientCIDRs").add(builder); } else { _visitables.get("serverAddressByClientCIDRs").set(index, builder);}
    if (index < 0 || index >= serverAddressByClientCIDRs.size()) { serverAddressByClientCIDRs.add(builder); } else { serverAddressByClientCIDRs.set(index, builder);}
     return (A)this;
  }
  public A addToServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... items) {
    if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder>();}
    for (io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item : items) {io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder builder = new io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").add(builder);this.serverAddressByClientCIDRs.add(builder);} return (A)this;
  }
  public A addAllToServerAddressByClientCIDRs(java.util.Collection<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR> items) {
    if (this.serverAddressByClientCIDRs == null) {this.serverAddressByClientCIDRs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder>();}
    for (io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item : items) {io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder builder = new io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").add(builder);this.serverAddressByClientCIDRs.add(builder);} return (A)this;
  }
  public A removeFromServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... items) {
    for (io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item : items) {io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder builder = new io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").remove(builder);if (this.serverAddressByClientCIDRs != null) {this.serverAddressByClientCIDRs.remove(builder);}} return (A)this;
  }
  public A removeAllFromServerAddressByClientCIDRs(java.util.Collection<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR> items) {
    for (io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item : items) {io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder builder = new io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder(item);_visitables.get("serverAddressByClientCIDRs").remove(builder);if (this.serverAddressByClientCIDRs != null) {this.serverAddressByClientCIDRs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServerAddressByClientCIDRs(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> predicate) {
    if (serverAddressByClientCIDRs == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> each = serverAddressByClientCIDRs.iterator();
    final List visitables = _visitables.get("serverAddressByClientCIDRs");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServerAddressByClientCIDRs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR> getServerAddressByClientCIDRs() {
    return build(serverAddressByClientCIDRs);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR> buildServerAddressByClientCIDRs() {
    return build(serverAddressByClientCIDRs);
  }
  public io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR buildServerAddressByClientCIDR(java.lang.Integer index) {
    return this.serverAddressByClientCIDRs.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR() {
    return this.serverAddressByClientCIDRs.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR buildLastServerAddressByClientCIDR() {
    return this.serverAddressByClientCIDRs.get(serverAddressByClientCIDRs.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder item: serverAddressByClientCIDRs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingServerAddressByClientCIDR(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder item: serverAddressByClientCIDRs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServerAddressByClientCIDRs(java.util.List<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
    if (this.serverAddressByClientCIDRs != null) { _visitables.get("serverAddressByClientCIDRs").removeAll(this.serverAddressByClientCIDRs);}
    if (serverAddressByClientCIDRs != null) {this.serverAddressByClientCIDRs = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item : serverAddressByClientCIDRs){this.addToServerAddressByClientCIDRs(item);}} else { this.serverAddressByClientCIDRs = null;} return (A) this;
  }
  public A withServerAddressByClientCIDRs(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR... serverAddressByClientCIDRs) {
    if (this.serverAddressByClientCIDRs != null) {this.serverAddressByClientCIDRs.clear();}
    if (serverAddressByClientCIDRs != null) {for (io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item :serverAddressByClientCIDRs){ this.addToServerAddressByClientCIDRs(item);}} return (A) this;
  }
  public java.lang.Boolean hasServerAddressByClientCIDRs() {
    return serverAddressByClientCIDRs != null && !serverAddressByClientCIDRs.isEmpty();
  }
  public A addNewServerAddressByClientCIDR(java.lang.String clientCIDR,java.lang.String serverAddress) {
    return (A)addToServerAddressByClientCIDRs(new ServerAddressByClientCIDR(clientCIDR, serverAddress));
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR() {
    return new io.fabric8.kubernetes.api.model.APIGroupFluentImpl.ServerAddressByClientCIDRsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item) {
    return new io.fabric8.kubernetes.api.model.APIGroupFluentImpl.ServerAddressByClientCIDRsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item) {
    return new io.fabric8.kubernetes.api.model.APIGroupFluentImpl.ServerAddressByClientCIDRsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(java.lang.Integer index) {
    if (serverAddressByClientCIDRs.size() <= index) throw new RuntimeException("Can't edit serverAddressByClientCIDRs. Index exceeds size.");
    return setNewServerAddressByClientCIDRLike(index, buildServerAddressByClientCIDR(index));
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR() {
    if (serverAddressByClientCIDRs.size() == 0) throw new RuntimeException("Can't edit first serverAddressByClientCIDRs. The list is empty.");
    return setNewServerAddressByClientCIDRLike(0, buildServerAddressByClientCIDR(0));
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR() {
    int index = serverAddressByClientCIDRs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serverAddressByClientCIDRs. The list is empty.");
    return setNewServerAddressByClientCIDRLike(index, buildServerAddressByClientCIDR(index));
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serverAddressByClientCIDRs.size();i++) { 
    if (predicate.test(serverAddressByClientCIDRs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serverAddressByClientCIDRs. No match found.");
    return setNewServerAddressByClientCIDRLike(index, buildServerAddressByClientCIDR(index));
  }
  public A addToVersions(java.lang.Integer index,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder>();}
    io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder builder = new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
  }
  public A setToVersions(java.lang.Integer index,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder>();}
    io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder builder = new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(item);
    if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
    if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
     return (A)this;
  }
  public A addToVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... items) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder>();}
    for (io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item : items) {io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder builder = new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A addAllToVersions(java.util.Collection<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery> items) {
    if (this.versions == null) {this.versions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder>();}
    for (io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item : items) {io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder builder = new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A removeFromVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... items) {
    for (io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item : items) {io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder builder = new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeAllFromVersions(java.util.Collection<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery> items) {
    for (io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item : items) {io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder builder = new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVersions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> predicate) {
    if (versions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> each = versions.iterator();
    final List visitables = _visitables.get("versions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVersions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery> getVersions() {
    return build(versions);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery> buildVersions() {
    return build(versions);
  }
  public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery buildVersion(java.lang.Integer index) {
    return this.versions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery buildFirstVersion() {
    return this.versions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery buildLastVersion() {
    return this.versions.get(versions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.GroupVersionForDiscovery buildMatchingVersion(java.util.function.Predicate<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder item: versions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingVersion(java.util.function.Predicate<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder item: versions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVersions(java.util.List<io.fabric8.kubernetes.api.model.GroupVersionForDiscovery> versions) {
    if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
    if (versions != null) {this.versions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
  }
  public A withVersions(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery... versions) {
    if (this.versions != null) {this.versions.clear();}
    if (versions != null) {for (io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item :versions){ this.addToVersions(item);}} return (A) this;
  }
  public java.lang.Boolean hasVersions() {
    return versions != null && !versions.isEmpty();
  }
  public A addNewVersion(java.lang.String groupVersion,java.lang.String version) {
    return (A)addToVersions(new GroupVersionForDiscovery(groupVersion, version));
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> addNewVersion() {
    return new io.fabric8.kubernetes.api.model.APIGroupFluentImpl.VersionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> addNewVersionLike(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item) {
    return new io.fabric8.kubernetes.api.model.APIGroupFluentImpl.VersionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> setNewVersionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item) {
    return new io.fabric8.kubernetes.api.model.APIGroupFluentImpl.VersionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editVersion(java.lang.Integer index) {
    if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editFirstVersion() {
    if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
    return setNewVersionLike(0, buildVersion(0));
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editLastVersion() {
    int index = versions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<A> editMatchingVersion(java.util.function.Predicate<io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<versions.size();i++) { 
    if (predicate.test(versions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    APIGroupFluentImpl that = (APIGroupFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (preferredVersion != null ? !preferredVersion.equals(that.preferredVersion) :that.preferredVersion != null) return false;
    if (serverAddressByClientCIDRs != null ? !serverAddressByClientCIDRs.equals(that.serverAddressByClientCIDRs) :that.serverAddressByClientCIDRs != null) return false;
    if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  name,  preferredVersion,  serverAddressByClientCIDRs,  versions,  additionalProperties,  super.hashCode());
  }
  public class PreferredVersionNestedImpl<N> extends io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluentImpl<io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<N>> implements io.fabric8.kubernetes.api.model.APIGroupFluent.PreferredVersionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PreferredVersionNestedImpl(io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item) {
      this.builder = new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(this, item);
    }
    PreferredVersionNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder builder;
    public N and() {
      return (N) APIGroupFluentImpl.this.withPreferredVersion(builder.build());
    }
    public N endPreferredVersion() {
      return and();
    }
    
  }
  public class ServerAddressByClientCIDRsNestedImpl<N> extends io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluentImpl<io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<N>> implements io.fabric8.kubernetes.api.model.APIGroupFluent.ServerAddressByClientCIDRsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ServerAddressByClientCIDRsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder(this, item);
    }
    ServerAddressByClientCIDRsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) APIGroupFluentImpl.this.setToServerAddressByClientCIDRs(index,builder.build());
    }
    public N endServerAddressByClientCIDR() {
      return and();
    }
    
  }
  public class VersionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryFluentImpl<io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<N>> implements io.fabric8.kubernetes.api.model.APIGroupFluent.VersionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VersionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.GroupVersionForDiscovery item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(this, item);
    }
    VersionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GroupVersionForDiscoveryBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) APIGroupFluentImpl.this.setToVersions(index,builder.build());
    }
    public N endVersion() {
      return and();
    }
    
  }
  
}