package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class SysctlBuilder extends io.fabric8.kubernetes.api.model.SysctlFluentImpl<io.fabric8.kubernetes.api.model.SysctlBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Sysctl,io.fabric8.kubernetes.api.model.SysctlBuilder>{
  public SysctlBuilder() {
    this(false);
  }
  public SysctlBuilder(java.lang.Boolean validationEnabled) {
    this(new Sysctl(), validationEnabled);
  }
  public SysctlBuilder(io.fabric8.kubernetes.api.model.SysctlFluent<?> fluent) {
    this(fluent, false);
  }
  public SysctlBuilder(io.fabric8.kubernetes.api.model.SysctlFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Sysctl(), validationEnabled);
  }
  public SysctlBuilder(io.fabric8.kubernetes.api.model.SysctlFluent<?> fluent,io.fabric8.kubernetes.api.model.Sysctl instance) {
    this(fluent, instance, false);
  }
  public SysctlBuilder(io.fabric8.kubernetes.api.model.SysctlFluent<?> fluent,io.fabric8.kubernetes.api.model.Sysctl instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SysctlBuilder(io.fabric8.kubernetes.api.model.Sysctl instance) {
    this(instance,false);
  }
  public SysctlBuilder(io.fabric8.kubernetes.api.model.Sysctl instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SysctlFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Sysctl build() {
    Sysctl buildable = new Sysctl(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SysctlBuilder that = (SysctlBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}