package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ObjectMetaFluentImpl<A extends io.fabric8.kubernetes.api.model.ObjectMetaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.ObjectMetaFluent<A>{
  public ObjectMetaFluentImpl() {
  }
  public ObjectMetaFluentImpl(io.fabric8.kubernetes.api.model.ObjectMeta instance) {
    this.withAnnotations(instance.getAnnotations()); 
    this.withClusterName(instance.getClusterName()); 
    this.withCreationTimestamp(instance.getCreationTimestamp()); 
    this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds()); 
    this.withDeletionTimestamp(instance.getDeletionTimestamp()); 
    this.withFinalizers(instance.getFinalizers()); 
    this.withGenerateName(instance.getGenerateName()); 
    this.withGeneration(instance.getGeneration()); 
    this.withLabels(instance.getLabels()); 
    this.withManagedFields(instance.getManagedFields()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withOwnerReferences(instance.getOwnerReferences()); 
    this.withResourceVersion(instance.getResourceVersion()); 
    this.withSelfLink(instance.getSelfLink()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.Map<java.lang.String,java.lang.String> annotations;
  private java.lang.String clusterName;
  private java.lang.String creationTimestamp;
  private java.lang.Long deletionGracePeriodSeconds;
  private java.lang.String deletionTimestamp;
  private java.util.List<java.lang.String> finalizers = new java.util.ArrayList<java.lang.String>();
  private java.lang.String generateName;
  private java.lang.Long generation;
  private java.util.Map<java.lang.String,java.lang.String> labels;
  private java.util.List<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder> managedFields =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder>();
  private java.lang.String name;
  private java.lang.String namespace;
  private java.util.List<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder> ownerReferences =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder>();
  private java.lang.String resourceVersion;
  private java.lang.String selfLink;
  private java.lang.String uid;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToAnnotations(java.lang.String key,java.lang.String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.annotations == null && map != null) { this.annotations = new java.util.LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(java.lang.String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(java.util.Map<java.lang.String,java.lang.String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new java.util.LinkedHashMap(annotations);} return (A) this;
  }
  public java.lang.Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public java.lang.String getClusterName() {
    return this.clusterName;
  }
  public A withClusterName(java.lang.String clusterName) {
    this.clusterName=clusterName; return (A) this;
  }
  public java.lang.Boolean hasClusterName() {
    return this.clusterName != null;
  }
  
  /**
   * Method is deprecated. use withClusterName instead.
   */
  @java.lang.Deprecated
  public A withNewClusterName(java.lang.String arg0) {
    return (A)withClusterName(new String(arg0));
  }
  public java.lang.String getCreationTimestamp() {
    return this.creationTimestamp;
  }
  public A withCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp=creationTimestamp; return (A) this;
  }
  public java.lang.Boolean hasCreationTimestamp() {
    return this.creationTimestamp != null;
  }
  
  /**
   * Method is deprecated. use withCreationTimestamp instead.
   */
  @java.lang.Deprecated
  public A withNewCreationTimestamp(java.lang.String arg0) {
    return (A)withCreationTimestamp(new String(arg0));
  }
  public java.lang.Long getDeletionGracePeriodSeconds() {
    return this.deletionGracePeriodSeconds;
  }
  public A withDeletionGracePeriodSeconds(java.lang.Long deletionGracePeriodSeconds) {
    this.deletionGracePeriodSeconds=deletionGracePeriodSeconds; return (A) this;
  }
  public java.lang.Boolean hasDeletionGracePeriodSeconds() {
    return this.deletionGracePeriodSeconds != null;
  }
  public java.lang.String getDeletionTimestamp() {
    return this.deletionTimestamp;
  }
  public A withDeletionTimestamp(java.lang.String deletionTimestamp) {
    this.deletionTimestamp=deletionTimestamp; return (A) this;
  }
  public java.lang.Boolean hasDeletionTimestamp() {
    return this.deletionTimestamp != null;
  }
  
  /**
   * Method is deprecated. use withDeletionTimestamp instead.
   */
  @java.lang.Deprecated
  public A withNewDeletionTimestamp(java.lang.String arg0) {
    return (A)withDeletionTimestamp(new String(arg0));
  }
  public A addToFinalizers(java.lang.Integer index,java.lang.String item) {
    if (this.finalizers == null) {this.finalizers = new java.util.ArrayList<java.lang.String>();}
    this.finalizers.add(index, item);
    return (A)this;
  }
  public A setToFinalizers(java.lang.Integer index,java.lang.String item) {
    if (this.finalizers == null) {this.finalizers = new java.util.ArrayList<java.lang.String>();}
    this.finalizers.set(index, item); return (A)this;
  }
  public A addToFinalizers(java.lang.String... items) {
    if (this.finalizers == null) {this.finalizers = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.finalizers.add(item);} return (A)this;
  }
  public A addAllToFinalizers(java.util.Collection<java.lang.String> items) {
    if (this.finalizers == null) {this.finalizers = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.finalizers.add(item);} return (A)this;
  }
  public A removeFromFinalizers(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.finalizers!= null){ this.finalizers.remove(item);}} return (A)this;
  }
  public A removeAllFromFinalizers(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.finalizers!= null){ this.finalizers.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getFinalizers() {
    return this.finalizers;
  }
  public java.lang.String getFinalizer(java.lang.Integer index) {
    return this.finalizers.get(index);
  }
  public java.lang.String getFirstFinalizer() {
    return this.finalizers.get(0);
  }
  public java.lang.String getLastFinalizer() {
    return this.finalizers.get(finalizers.size() - 1);
  }
  public java.lang.String getMatchingFinalizer(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: finalizers) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingFinalizer(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: finalizers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFinalizers(java.util.List<java.lang.String> finalizers) {
    if (finalizers != null) {this.finalizers = new java.util.ArrayList(); for (java.lang.String item : finalizers){this.addToFinalizers(item);}} else { this.finalizers = null;} return (A) this;
  }
  public A withFinalizers(java.lang.String... finalizers) {
    if (this.finalizers != null) {this.finalizers.clear();}
    if (finalizers != null) {for (java.lang.String item :finalizers){ this.addToFinalizers(item);}} return (A) this;
  }
  public java.lang.Boolean hasFinalizers() {
    return finalizers != null && !finalizers.isEmpty();
  }
  public A addNewFinalizer(java.lang.String arg0) {
    return (A)addToFinalizers(new String(arg0));
  }
  public java.lang.String getGenerateName() {
    return this.generateName;
  }
  public A withGenerateName(java.lang.String generateName) {
    this.generateName=generateName; return (A) this;
  }
  public java.lang.Boolean hasGenerateName() {
    return this.generateName != null;
  }
  
  /**
   * Method is deprecated. use withGenerateName instead.
   */
  @java.lang.Deprecated
  public A withNewGenerateName(java.lang.String arg0) {
    return (A)withGenerateName(new String(arg0));
  }
  public java.lang.Long getGeneration() {
    return this.generation;
  }
  public A withGeneration(java.lang.Long generation) {
    this.generation=generation; return (A) this;
  }
  public java.lang.Boolean hasGeneration() {
    return this.generation != null;
  }
  public A addToLabels(java.lang.String key,java.lang.String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.labels == null && map != null) { this.labels = new java.util.LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(java.lang.String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(java.util.Map<java.lang.String,java.lang.String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new java.util.LinkedHashMap(labels);} return (A) this;
  }
  public java.lang.Boolean hasLabels() {
    return this.labels != null;
  }
  public A addToManagedFields(java.lang.Integer index,io.fabric8.kubernetes.api.model.ManagedFieldsEntry item) {
    if (this.managedFields == null) {this.managedFields = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder>();}
    io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder builder = new io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder(item);_visitables.get("managedFields").add(index >= 0 ? index : _visitables.get("managedFields").size(), builder);this.managedFields.add(index >= 0 ? index : managedFields.size(), builder); return (A)this;
  }
  public A setToManagedFields(java.lang.Integer index,io.fabric8.kubernetes.api.model.ManagedFieldsEntry item) {
    if (this.managedFields == null) {this.managedFields = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder>();}
    io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder builder = new io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("managedFields").size()) { _visitables.get("managedFields").add(builder); } else { _visitables.get("managedFields").set(index, builder);}
    if (index < 0 || index >= managedFields.size()) { managedFields.add(builder); } else { managedFields.set(index, builder);}
     return (A)this;
  }
  public A addToManagedFields(io.fabric8.kubernetes.api.model.ManagedFieldsEntry... items) {
    if (this.managedFields == null) {this.managedFields = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder>();}
    for (io.fabric8.kubernetes.api.model.ManagedFieldsEntry item : items) {io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder builder = new io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder(item);_visitables.get("managedFields").add(builder);this.managedFields.add(builder);} return (A)this;
  }
  public A addAllToManagedFields(java.util.Collection<io.fabric8.kubernetes.api.model.ManagedFieldsEntry> items) {
    if (this.managedFields == null) {this.managedFields = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder>();}
    for (io.fabric8.kubernetes.api.model.ManagedFieldsEntry item : items) {io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder builder = new io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder(item);_visitables.get("managedFields").add(builder);this.managedFields.add(builder);} return (A)this;
  }
  public A removeFromManagedFields(io.fabric8.kubernetes.api.model.ManagedFieldsEntry... items) {
    for (io.fabric8.kubernetes.api.model.ManagedFieldsEntry item : items) {io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder builder = new io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder(item);_visitables.get("managedFields").remove(builder);if (this.managedFields != null) {this.managedFields.remove(builder);}} return (A)this;
  }
  public A removeAllFromManagedFields(java.util.Collection<io.fabric8.kubernetes.api.model.ManagedFieldsEntry> items) {
    for (io.fabric8.kubernetes.api.model.ManagedFieldsEntry item : items) {io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder builder = new io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder(item);_visitables.get("managedFields").remove(builder);if (this.managedFields != null) {this.managedFields.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromManagedFields(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder> predicate) {
    if (managedFields == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder> each = managedFields.iterator();
    final List visitables = _visitables.get("managedFields");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildManagedFields instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ManagedFieldsEntry> getManagedFields() {
    return build(managedFields);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ManagedFieldsEntry> buildManagedFields() {
    return build(managedFields);
  }
  public io.fabric8.kubernetes.api.model.ManagedFieldsEntry buildManagedField(java.lang.Integer index) {
    return this.managedFields.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ManagedFieldsEntry buildFirstManagedField() {
    return this.managedFields.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ManagedFieldsEntry buildLastManagedField() {
    return this.managedFields.get(managedFields.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ManagedFieldsEntry buildMatchingManagedField(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder item: managedFields) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingManagedField(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder item: managedFields) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withManagedFields(java.util.List<io.fabric8.kubernetes.api.model.ManagedFieldsEntry> managedFields) {
    if (this.managedFields != null) { _visitables.get("managedFields").removeAll(this.managedFields);}
    if (managedFields != null) {this.managedFields = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.ManagedFieldsEntry item : managedFields){this.addToManagedFields(item);}} else { this.managedFields = null;} return (A) this;
  }
  public A withManagedFields(io.fabric8.kubernetes.api.model.ManagedFieldsEntry... managedFields) {
    if (this.managedFields != null) {this.managedFields.clear();}
    if (managedFields != null) {for (io.fabric8.kubernetes.api.model.ManagedFieldsEntry item :managedFields){ this.addToManagedFields(item);}} return (A) this;
  }
  public java.lang.Boolean hasManagedFields() {
    return managedFields != null && !managedFields.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedField() {
    return new io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl.ManagedFieldsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedFieldLike(io.fabric8.kubernetes.api.model.ManagedFieldsEntry item) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl.ManagedFieldsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.ManagedFieldsNested<A> setNewManagedFieldLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ManagedFieldsEntry item) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl.ManagedFieldsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.ManagedFieldsNested<A> editManagedField(java.lang.Integer index) {
    if (managedFields.size() <= index) throw new RuntimeException("Can't edit managedFields. Index exceeds size.");
    return setNewManagedFieldLike(index, buildManagedField(index));
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.ManagedFieldsNested<A> editFirstManagedField() {
    if (managedFields.size() == 0) throw new RuntimeException("Can't edit first managedFields. The list is empty.");
    return setNewManagedFieldLike(0, buildManagedField(0));
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.ManagedFieldsNested<A> editLastManagedField() {
    int index = managedFields.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last managedFields. The list is empty.");
    return setNewManagedFieldLike(index, buildManagedField(index));
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.ManagedFieldsNested<A> editMatchingManagedField(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<managedFields.size();i++) { 
    if (predicate.test(managedFields.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching managedFields. No match found.");
    return setNewManagedFieldLike(index, buildManagedField(index));
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * Method is deprecated. use withName instead.
   */
  @java.lang.Deprecated
  public A withNewName(java.lang.String arg0) {
    return (A)withName(new String(arg0));
  }
  public java.lang.String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(java.lang.String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public java.lang.Boolean hasNamespace() {
    return this.namespace != null;
  }
  
  /**
   * Method is deprecated. use withNamespace instead.
   */
  @java.lang.Deprecated
  public A withNewNamespace(java.lang.String arg0) {
    return (A)withNamespace(new String(arg0));
  }
  public A addToOwnerReferences(java.lang.Integer index,io.fabric8.kubernetes.api.model.OwnerReference item) {
    if (this.ownerReferences == null) {this.ownerReferences = new java.util.ArrayList<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder>();}
    io.fabric8.kubernetes.api.model.OwnerReferenceBuilder builder = new io.fabric8.kubernetes.api.model.OwnerReferenceBuilder(item);_visitables.get("ownerReferences").add(index >= 0 ? index : _visitables.get("ownerReferences").size(), builder);this.ownerReferences.add(index >= 0 ? index : ownerReferences.size(), builder); return (A)this;
  }
  public A setToOwnerReferences(java.lang.Integer index,io.fabric8.kubernetes.api.model.OwnerReference item) {
    if (this.ownerReferences == null) {this.ownerReferences = new java.util.ArrayList<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder>();}
    io.fabric8.kubernetes.api.model.OwnerReferenceBuilder builder = new io.fabric8.kubernetes.api.model.OwnerReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("ownerReferences").size()) { _visitables.get("ownerReferences").add(builder); } else { _visitables.get("ownerReferences").set(index, builder);}
    if (index < 0 || index >= ownerReferences.size()) { ownerReferences.add(builder); } else { ownerReferences.set(index, builder);}
     return (A)this;
  }
  public A addToOwnerReferences(io.fabric8.kubernetes.api.model.OwnerReference... items) {
    if (this.ownerReferences == null) {this.ownerReferences = new java.util.ArrayList<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder>();}
    for (io.fabric8.kubernetes.api.model.OwnerReference item : items) {io.fabric8.kubernetes.api.model.OwnerReferenceBuilder builder = new io.fabric8.kubernetes.api.model.OwnerReferenceBuilder(item);_visitables.get("ownerReferences").add(builder);this.ownerReferences.add(builder);} return (A)this;
  }
  public A addAllToOwnerReferences(java.util.Collection<io.fabric8.kubernetes.api.model.OwnerReference> items) {
    if (this.ownerReferences == null) {this.ownerReferences = new java.util.ArrayList<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder>();}
    for (io.fabric8.kubernetes.api.model.OwnerReference item : items) {io.fabric8.kubernetes.api.model.OwnerReferenceBuilder builder = new io.fabric8.kubernetes.api.model.OwnerReferenceBuilder(item);_visitables.get("ownerReferences").add(builder);this.ownerReferences.add(builder);} return (A)this;
  }
  public A removeFromOwnerReferences(io.fabric8.kubernetes.api.model.OwnerReference... items) {
    for (io.fabric8.kubernetes.api.model.OwnerReference item : items) {io.fabric8.kubernetes.api.model.OwnerReferenceBuilder builder = new io.fabric8.kubernetes.api.model.OwnerReferenceBuilder(item);_visitables.get("ownerReferences").remove(builder);if (this.ownerReferences != null) {this.ownerReferences.remove(builder);}} return (A)this;
  }
  public A removeAllFromOwnerReferences(java.util.Collection<io.fabric8.kubernetes.api.model.OwnerReference> items) {
    for (io.fabric8.kubernetes.api.model.OwnerReference item : items) {io.fabric8.kubernetes.api.model.OwnerReferenceBuilder builder = new io.fabric8.kubernetes.api.model.OwnerReferenceBuilder(item);_visitables.get("ownerReferences").remove(builder);if (this.ownerReferences != null) {this.ownerReferences.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOwnerReferences(java.util.function.Predicate<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder> predicate) {
    if (ownerReferences == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder> each = ownerReferences.iterator();
    final List visitables = _visitables.get("ownerReferences");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.OwnerReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildOwnerReferences instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.OwnerReference> getOwnerReferences() {
    return build(ownerReferences);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.OwnerReference> buildOwnerReferences() {
    return build(ownerReferences);
  }
  public io.fabric8.kubernetes.api.model.OwnerReference buildOwnerReference(java.lang.Integer index) {
    return this.ownerReferences.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.OwnerReference buildFirstOwnerReference() {
    return this.ownerReferences.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.OwnerReference buildLastOwnerReference() {
    return this.ownerReferences.get(ownerReferences.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.OwnerReference buildMatchingOwnerReference(java.util.function.Predicate<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.OwnerReferenceBuilder item: ownerReferences) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingOwnerReference(java.util.function.Predicate<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.OwnerReferenceBuilder item: ownerReferences) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOwnerReferences(java.util.List<io.fabric8.kubernetes.api.model.OwnerReference> ownerReferences) {
    if (this.ownerReferences != null) { _visitables.get("ownerReferences").removeAll(this.ownerReferences);}
    if (ownerReferences != null) {this.ownerReferences = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.OwnerReference item : ownerReferences){this.addToOwnerReferences(item);}} else { this.ownerReferences = null;} return (A) this;
  }
  public A withOwnerReferences(io.fabric8.kubernetes.api.model.OwnerReference... ownerReferences) {
    if (this.ownerReferences != null) {this.ownerReferences.clear();}
    if (ownerReferences != null) {for (io.fabric8.kubernetes.api.model.OwnerReference item :ownerReferences){ this.addToOwnerReferences(item);}} return (A) this;
  }
  public java.lang.Boolean hasOwnerReferences() {
    return ownerReferences != null && !ownerReferences.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReference() {
    return new io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl.OwnerReferencesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReferenceLike(io.fabric8.kubernetes.api.model.OwnerReference item) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl.OwnerReferencesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.OwnerReferencesNested<A> setNewOwnerReferenceLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.OwnerReference item) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl.OwnerReferencesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.OwnerReferencesNested<A> editOwnerReference(java.lang.Integer index) {
    if (ownerReferences.size() <= index) throw new RuntimeException("Can't edit ownerReferences. Index exceeds size.");
    return setNewOwnerReferenceLike(index, buildOwnerReference(index));
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.OwnerReferencesNested<A> editFirstOwnerReference() {
    if (ownerReferences.size() == 0) throw new RuntimeException("Can't edit first ownerReferences. The list is empty.");
    return setNewOwnerReferenceLike(0, buildOwnerReference(0));
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.OwnerReferencesNested<A> editLastOwnerReference() {
    int index = ownerReferences.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ownerReferences. The list is empty.");
    return setNewOwnerReferenceLike(index, buildOwnerReference(index));
  }
  public io.fabric8.kubernetes.api.model.ObjectMetaFluent.OwnerReferencesNested<A> editMatchingOwnerReference(java.util.function.Predicate<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ownerReferences.size();i++) { 
    if (predicate.test(ownerReferences.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ownerReferences. No match found.");
    return setNewOwnerReferenceLike(index, buildOwnerReference(index));
  }
  public java.lang.String getResourceVersion() {
    return this.resourceVersion;
  }
  public A withResourceVersion(java.lang.String resourceVersion) {
    this.resourceVersion=resourceVersion; return (A) this;
  }
  public java.lang.Boolean hasResourceVersion() {
    return this.resourceVersion != null;
  }
  
  /**
   * Method is deprecated. use withResourceVersion instead.
   */
  @java.lang.Deprecated
  public A withNewResourceVersion(java.lang.String arg0) {
    return (A)withResourceVersion(new String(arg0));
  }
  public java.lang.String getSelfLink() {
    return this.selfLink;
  }
  public A withSelfLink(java.lang.String selfLink) {
    this.selfLink=selfLink; return (A) this;
  }
  public java.lang.Boolean hasSelfLink() {
    return this.selfLink != null;
  }
  
  /**
   * Method is deprecated. use withSelfLink instead.
   */
  @java.lang.Deprecated
  public A withNewSelfLink(java.lang.String arg0) {
    return (A)withSelfLink(new String(arg0));
  }
  public java.lang.String getUid() {
    return this.uid;
  }
  public A withUid(java.lang.String uid) {
    this.uid=uid; return (A) this;
  }
  public java.lang.Boolean hasUid() {
    return this.uid != null;
  }
  
  /**
   * Method is deprecated. use withUid instead.
   */
  @java.lang.Deprecated
  public A withNewUid(java.lang.String arg0) {
    return (A)withUid(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ObjectMetaFluentImpl that = (ObjectMetaFluentImpl) o;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (clusterName != null ? !clusterName.equals(that.clusterName) :that.clusterName != null) return false;
    if (creationTimestamp != null ? !creationTimestamp.equals(that.creationTimestamp) :that.creationTimestamp != null) return false;
    if (deletionGracePeriodSeconds != null ? !deletionGracePeriodSeconds.equals(that.deletionGracePeriodSeconds) :that.deletionGracePeriodSeconds != null) return false;
    if (deletionTimestamp != null ? !deletionTimestamp.equals(that.deletionTimestamp) :that.deletionTimestamp != null) return false;
    if (finalizers != null ? !finalizers.equals(that.finalizers) :that.finalizers != null) return false;
    if (generateName != null ? !generateName.equals(that.generateName) :that.generateName != null) return false;
    if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (managedFields != null ? !managedFields.equals(that.managedFields) :that.managedFields != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (ownerReferences != null ? !ownerReferences.equals(that.ownerReferences) :that.ownerReferences != null) return false;
    if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
    if (selfLink != null ? !selfLink.equals(that.selfLink) :that.selfLink != null) return false;
    if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  clusterName,  creationTimestamp,  deletionGracePeriodSeconds,  deletionTimestamp,  finalizers,  generateName,  generation,  labels,  managedFields,  name,  namespace,  ownerReferences,  resourceVersion,  selfLink,  uid,  additionalProperties,  super.hashCode());
  }
  public class ManagedFieldsNestedImpl<N> extends io.fabric8.kubernetes.api.model.ManagedFieldsEntryFluentImpl<io.fabric8.kubernetes.api.model.ObjectMetaFluent.ManagedFieldsNested<N>> implements io.fabric8.kubernetes.api.model.ObjectMetaFluent.ManagedFieldsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ManagedFieldsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ManagedFieldsEntry item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder(this, item);
    }
    ManagedFieldsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ObjectMetaFluentImpl.this.setToManagedFields(index,builder.build());
    }
    public N endManagedField() {
      return and();
    }
    
  }
  public class OwnerReferencesNestedImpl<N> extends io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl<io.fabric8.kubernetes.api.model.ObjectMetaFluent.OwnerReferencesNested<N>> implements io.fabric8.kubernetes.api.model.ObjectMetaFluent.OwnerReferencesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OwnerReferencesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.OwnerReference item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.OwnerReferenceBuilder(this, item);
    }
    OwnerReferencesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.OwnerReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.OwnerReferenceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ObjectMetaFluentImpl.this.setToOwnerReferences(index,builder.build());
    }
    public N endOwnerReference() {
      return and();
    }
    
  }
  
}