package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NodeAddressBuilder extends io.fabric8.kubernetes.api.model.NodeAddressFluentImpl<io.fabric8.kubernetes.api.model.NodeAddressBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.NodeAddress,io.fabric8.kubernetes.api.model.NodeAddressBuilder>{
  public NodeAddressBuilder() {
    this(false);
  }
  public NodeAddressBuilder(java.lang.Boolean validationEnabled) {
    this(new NodeAddress(), validationEnabled);
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddressFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddressFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeAddress(), validationEnabled);
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddressFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeAddress instance) {
    this(fluent, instance, false);
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddressFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeAddress instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddress(instance.getAddress()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddress instance) {
    this(instance,false);
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddress instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddress(instance.getAddress()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeAddressFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeAddress build() {
    NodeAddress buildable = new NodeAddress(fluent.getAddress(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeAddressBuilder that = (NodeAddressBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}