package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class APIResourceListBuilder extends io.fabric8.kubernetes.api.model.APIResourceListFluentImpl<io.fabric8.kubernetes.api.model.APIResourceListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.APIResourceList,io.fabric8.kubernetes.api.model.APIResourceListBuilder>{
  public APIResourceListBuilder() {
    this(false);
  }
  public APIResourceListBuilder(java.lang.Boolean validationEnabled) {
    this(new APIResourceList(), validationEnabled);
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceListFluent<?> fluent) {
    this(fluent, false);
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new APIResourceList(), validationEnabled);
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceListFluent<?> fluent,io.fabric8.kubernetes.api.model.APIResourceList instance) {
    this(fluent, instance, false);
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceListFluent<?> fluent,io.fabric8.kubernetes.api.model.APIResourceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withGroupVersion(instance.getGroupVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withResources(instance.getResources()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceList instance) {
    this(instance,false);
  }
  public APIResourceListBuilder(io.fabric8.kubernetes.api.model.APIResourceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withGroupVersion(instance.getGroupVersion()); 
    this.withKind(instance.getKind()); 
    this.withResources(instance.getResources()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.APIResourceListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.APIResourceList build() {
    APIResourceList buildable = new APIResourceList(fluent.getApiVersion(),fluent.getGroupVersion(),fluent.getKind(),fluent.getResources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIResourceListBuilder that = (APIResourceListBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}