package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ConfigMapListBuilder extends io.fabric8.kubernetes.api.model.ConfigMapListFluentImpl<io.fabric8.kubernetes.api.model.ConfigMapListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ConfigMapList,io.fabric8.kubernetes.api.model.ConfigMapListBuilder>{
  public ConfigMapListBuilder() {
    this(false);
  }
  public ConfigMapListBuilder(java.lang.Boolean validationEnabled) {
    this(new ConfigMapList(), validationEnabled);
  }
  public ConfigMapListBuilder(io.fabric8.kubernetes.api.model.ConfigMapListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapListBuilder(io.fabric8.kubernetes.api.model.ConfigMapListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConfigMapList(), validationEnabled);
  }
  public ConfigMapListBuilder(io.fabric8.kubernetes.api.model.ConfigMapListFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapList instance) {
    this(fluent, instance, false);
  }
  public ConfigMapListBuilder(io.fabric8.kubernetes.api.model.ConfigMapListFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapListBuilder(io.fabric8.kubernetes.api.model.ConfigMapList instance) {
    this(instance,false);
  }
  public ConfigMapListBuilder(io.fabric8.kubernetes.api.model.ConfigMapList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ConfigMapListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ConfigMapList build() {
    ConfigMapList buildable = new ConfigMapList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConfigMapListBuilder that = (ConfigMapListBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}