package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class HTTPHeaderBuilder extends io.fabric8.kubernetes.api.model.HTTPHeaderFluentImpl<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.HTTPHeader,io.fabric8.kubernetes.api.model.HTTPHeaderBuilder>{
  public HTTPHeaderBuilder() {
    this(false);
  }
  public HTTPHeaderBuilder(java.lang.Boolean validationEnabled) {
    this(new HTTPHeader(), validationEnabled);
  }
  public HTTPHeaderBuilder(io.fabric8.kubernetes.api.model.HTTPHeaderFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPHeaderBuilder(io.fabric8.kubernetes.api.model.HTTPHeaderFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HTTPHeader(), validationEnabled);
  }
  public HTTPHeaderBuilder(io.fabric8.kubernetes.api.model.HTTPHeaderFluent<?> fluent,io.fabric8.kubernetes.api.model.HTTPHeader instance) {
    this(fluent, instance, false);
  }
  public HTTPHeaderBuilder(io.fabric8.kubernetes.api.model.HTTPHeaderFluent<?> fluent,io.fabric8.kubernetes.api.model.HTTPHeader instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPHeaderBuilder(io.fabric8.kubernetes.api.model.HTTPHeader instance) {
    this(instance,false);
  }
  public HTTPHeaderBuilder(io.fabric8.kubernetes.api.model.HTTPHeader instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.HTTPHeaderFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.HTTPHeader build() {
    HTTPHeader buildable = new HTTPHeader(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPHeaderBuilder that = (HTTPHeaderBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}