package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class EndpointSubsetBuilder extends io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl<io.fabric8.kubernetes.api.model.EndpointSubsetBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.EndpointSubset,io.fabric8.kubernetes.api.model.EndpointSubsetBuilder>{
  public EndpointSubsetBuilder() {
    this(false);
  }
  public EndpointSubsetBuilder(java.lang.Boolean validationEnabled) {
    this(new EndpointSubset(), validationEnabled);
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubsetFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubsetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EndpointSubset(), validationEnabled);
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubsetFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointSubset instance) {
    this(fluent, instance, false);
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubsetFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointSubset instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddresses(instance.getAddresses()); 
    fluent.withNotReadyAddresses(instance.getNotReadyAddresses()); 
    fluent.withPorts(instance.getPorts()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubset instance) {
    this(instance,false);
  }
  public EndpointSubsetBuilder(io.fabric8.kubernetes.api.model.EndpointSubset instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddresses(instance.getAddresses()); 
    this.withNotReadyAddresses(instance.getNotReadyAddresses()); 
    this.withPorts(instance.getPorts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.EndpointSubsetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.EndpointSubset build() {
    EndpointSubset buildable = new EndpointSubset(fluent.getAddresses(),fluent.getNotReadyAddresses(),fluent.getPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointSubsetBuilder that = (EndpointSubsetBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}