package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class ExecConfigFluentImpl<A extends io.fabric8.kubernetes.api.model.ExecConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.ExecConfigFluent<A>{
  public ExecConfigFluentImpl() {
  }
  public ExecConfigFluentImpl(io.fabric8.kubernetes.api.model.ExecConfig instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withArgs(instance.getArgs()); 
    this.withCommand(instance.getCommand()); 
    this.withEnv(instance.getEnv()); 
    this.withInstallHint(instance.getInstallHint()); 
    this.withInteractiveMode(instance.getInteractiveMode()); 
    this.withProvideClusterInfo(instance.getProvideClusterInfo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private java.util.List<java.lang.String> args = new java.util.ArrayList<java.lang.String>();
  private java.lang.String command;
  private java.util.List<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder> env =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder>();
  private java.lang.String installHint;
  private java.lang.String interactiveMode;
  private java.lang.Boolean provideClusterInfo;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public A addToArgs(java.lang.Integer index,java.lang.String item) {
    if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
    this.args.add(index, item);
    return (A)this;
  }
  public A setToArgs(java.lang.Integer index,java.lang.String item) {
    if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
    this.args.set(index, item); return (A)this;
  }
  public A addToArgs(java.lang.String... items) {
    if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.args.add(item);} return (A)this;
  }
  public A addAllToArgs(java.util.Collection<java.lang.String> items) {
    if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.args.add(item);} return (A)this;
  }
  public A removeFromArgs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
  }
  public A removeAllFromArgs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getArgs() {
    return this.args;
  }
  public java.lang.String getArg(java.lang.Integer index) {
    return this.args.get(index);
  }
  public java.lang.String getFirstArg() {
    return this.args.get(0);
  }
  public java.lang.String getLastArg() {
    return this.args.get(args.size() - 1);
  }
  public java.lang.String getMatchingArg(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: args) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingArg(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: args) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withArgs(java.util.List<java.lang.String> args) {
    if (args != null) {this.args = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : args){this.addToArgs(item);}} else { this.args = null;} return (A) this;
  }
  public A withArgs(java.lang.String... args) {
    if (this.args != null) {this.args.clear();}
    if (args != null) {for (java.lang.String item :args){ this.addToArgs(item);}} return (A) this;
  }
  public java.lang.Boolean hasArgs() {
    return args != null && !args.isEmpty();
  }
  public A addNewArg(java.lang.String arg0) {
    return (A)addToArgs(new String(arg0));
  }
  public java.lang.String getCommand() {
    return this.command;
  }
  public A withCommand(java.lang.String command) {
    this.command=command; return (A) this;
  }
  public java.lang.Boolean hasCommand() {
    return this.command != null;
  }
  
  /**
   * Method is deprecated. use withCommand instead.
   */
  @java.lang.Deprecated
  public A withNewCommand(java.lang.String arg0) {
    return (A)withCommand(new String(arg0));
  }
  public A addToEnv(java.lang.Integer index,io.fabric8.kubernetes.api.model.ExecEnvVar item) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder>();}
    io.fabric8.kubernetes.api.model.ExecEnvVarBuilder builder = new io.fabric8.kubernetes.api.model.ExecEnvVarBuilder(item);_visitables.get("env").add(index >= 0 ? index : _visitables.get("env").size(), builder);this.env.add(index >= 0 ? index : env.size(), builder); return (A)this;
  }
  public A setToEnv(java.lang.Integer index,io.fabric8.kubernetes.api.model.ExecEnvVar item) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder>();}
    io.fabric8.kubernetes.api.model.ExecEnvVarBuilder builder = new io.fabric8.kubernetes.api.model.ExecEnvVarBuilder(item);
    if (index < 0 || index >= _visitables.get("env").size()) { _visitables.get("env").add(builder); } else { _visitables.get("env").set(index, builder);}
    if (index < 0 || index >= env.size()) { env.add(builder); } else { env.set(index, builder);}
     return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.ExecEnvVar... items) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder>();}
    for (io.fabric8.kubernetes.api.model.ExecEnvVar item : items) {io.fabric8.kubernetes.api.model.ExecEnvVarBuilder builder = new io.fabric8.kubernetes.api.model.ExecEnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A addAllToEnv(java.util.Collection<io.fabric8.kubernetes.api.model.ExecEnvVar> items) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder>();}
    for (io.fabric8.kubernetes.api.model.ExecEnvVar item : items) {io.fabric8.kubernetes.api.model.ExecEnvVarBuilder builder = new io.fabric8.kubernetes.api.model.ExecEnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.ExecEnvVar... items) {
    for (io.fabric8.kubernetes.api.model.ExecEnvVar item : items) {io.fabric8.kubernetes.api.model.ExecEnvVarBuilder builder = new io.fabric8.kubernetes.api.model.ExecEnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
  }
  public A removeAllFromEnv(java.util.Collection<io.fabric8.kubernetes.api.model.ExecEnvVar> items) {
    for (io.fabric8.kubernetes.api.model.ExecEnvVar item : items) {io.fabric8.kubernetes.api.model.ExecEnvVarBuilder builder = new io.fabric8.kubernetes.api.model.ExecEnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder> predicate) {
    if (env == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder> each = env.iterator();
    final List visitables = _visitables.get("env");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ExecEnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEnv instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ExecEnvVar> getEnv() {
    return build(env);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ExecEnvVar> buildEnv() {
    return build(env);
  }
  public io.fabric8.kubernetes.api.model.ExecEnvVar buildEnv(java.lang.Integer index) {
    return this.env.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ExecEnvVar buildFirstEnv() {
    return this.env.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ExecEnvVar buildLastEnv() {
    return this.env.get(env.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ExecEnvVar buildMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ExecEnvVarBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ExecEnvVarBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(java.util.List<io.fabric8.kubernetes.api.model.ExecEnvVar> env) {
    if (this.env != null) { _visitables.get("env").removeAll(this.env);}
    if (env != null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder>(); for (io.fabric8.kubernetes.api.model.ExecEnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.ExecEnvVar... env) {
    if (this.env != null) {this.env.clear();}
    if (env != null) {for (io.fabric8.kubernetes.api.model.ExecEnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public java.lang.Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public A addNewEnv(java.lang.String name,java.lang.String value) {
    return (A)addToEnv(new ExecEnvVar(name, value));
  }
  public io.fabric8.kubernetes.api.model.ExecConfigFluent.EnvNested<A> addNewEnv() {
    return new io.fabric8.kubernetes.api.model.ExecConfigFluentImpl.EnvNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ExecConfigFluent.EnvNested<A> addNewEnvLike(io.fabric8.kubernetes.api.model.ExecEnvVar item) {
    return new io.fabric8.kubernetes.api.model.ExecConfigFluentImpl.EnvNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ExecConfigFluent.EnvNested<A> setNewEnvLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ExecEnvVar item) {
    return new io.fabric8.kubernetes.api.model.ExecConfigFluentImpl.EnvNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ExecConfigFluent.EnvNested<A> editEnv(java.lang.Integer index) {
    if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public io.fabric8.kubernetes.api.model.ExecConfigFluent.EnvNested<A> editFirstEnv() {
    if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
    return setNewEnvLike(0, buildEnv(0));
  }
  public io.fabric8.kubernetes.api.model.ExecConfigFluent.EnvNested<A> editLastEnv() {
    int index = env.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public io.fabric8.kubernetes.api.model.ExecConfigFluent.EnvNested<A> editMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ExecEnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<env.size();i++) { 
    if (predicate.test(env.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public java.lang.String getInstallHint() {
    return this.installHint;
  }
  public A withInstallHint(java.lang.String installHint) {
    this.installHint=installHint; return (A) this;
  }
  public java.lang.Boolean hasInstallHint() {
    return this.installHint != null;
  }
  
  /**
   * Method is deprecated. use withInstallHint instead.
   */
  @java.lang.Deprecated
  public A withNewInstallHint(java.lang.String arg0) {
    return (A)withInstallHint(new String(arg0));
  }
  public java.lang.String getInteractiveMode() {
    return this.interactiveMode;
  }
  public A withInteractiveMode(java.lang.String interactiveMode) {
    this.interactiveMode=interactiveMode; return (A) this;
  }
  public java.lang.Boolean hasInteractiveMode() {
    return this.interactiveMode != null;
  }
  
  /**
   * Method is deprecated. use withInteractiveMode instead.
   */
  @java.lang.Deprecated
  public A withNewInteractiveMode(java.lang.String arg0) {
    return (A)withInteractiveMode(new String(arg0));
  }
  public java.lang.Boolean getProvideClusterInfo() {
    return this.provideClusterInfo;
  }
  public A withProvideClusterInfo(java.lang.Boolean provideClusterInfo) {
    this.provideClusterInfo=provideClusterInfo; return (A) this;
  }
  public java.lang.Boolean hasProvideClusterInfo() {
    return this.provideClusterInfo != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExecConfigFluentImpl that = (ExecConfigFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (args != null ? !args.equals(that.args) :that.args != null) return false;
    if (command != null ? !command.equals(that.command) :that.command != null) return false;
    if (env != null ? !env.equals(that.env) :that.env != null) return false;
    if (installHint != null ? !installHint.equals(that.installHint) :that.installHint != null) return false;
    if (interactiveMode != null ? !interactiveMode.equals(that.interactiveMode) :that.interactiveMode != null) return false;
    if (provideClusterInfo != null ? !provideClusterInfo.equals(that.provideClusterInfo) :that.provideClusterInfo != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  args,  command,  env,  installHint,  interactiveMode,  provideClusterInfo,  additionalProperties,  super.hashCode());
  }
  public class EnvNestedImpl<N> extends io.fabric8.kubernetes.api.model.ExecEnvVarFluentImpl<io.fabric8.kubernetes.api.model.ExecConfigFluent.EnvNested<N>> implements io.fabric8.kubernetes.api.model.ExecConfigFluent.EnvNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EnvNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ExecEnvVar item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ExecEnvVarBuilder(this, item);
    }
    EnvNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ExecEnvVarBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ExecEnvVarBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ExecConfigFluentImpl.this.setToEnv(index,builder.build());
    }
    public N endEnv() {
      return and();
    }
    
  }
  
}