package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class NodeSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.NodeSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.NodeSpecFluent<A>{
  public NodeSpecFluentImpl() {
  }
  public NodeSpecFluentImpl(io.fabric8.kubernetes.api.model.NodeSpec instance) {
    this.withConfigSource(instance.getConfigSource()); 
    this.withExternalID(instance.getExternalID()); 
    this.withPodCIDR(instance.getPodCIDR()); 
    this.withPodCIDRs(instance.getPodCIDRs()); 
    this.withProviderID(instance.getProviderID()); 
    this.withTaints(instance.getTaints()); 
    this.withUnschedulable(instance.getUnschedulable()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private io.fabric8.kubernetes.api.model.NodeConfigSourceBuilder configSource;
  private java.lang.String externalID;
  private java.lang.String podCIDR;
  private java.util.List<java.lang.String> podCIDRs = new java.util.ArrayList<java.lang.String>();
  private java.lang.String providerID;
  private java.util.List<io.fabric8.kubernetes.api.model.TaintBuilder> taints =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.TaintBuilder>();
  private java.lang.Boolean unschedulable;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildConfigSource instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.NodeConfigSource getConfigSource() {
    return this.configSource!=null?this.configSource.build():null;
  }
  public io.fabric8.kubernetes.api.model.NodeConfigSource buildConfigSource() {
    return this.configSource!=null?this.configSource.build():null;
  }
  public A withConfigSource(io.fabric8.kubernetes.api.model.NodeConfigSource configSource) {
    _visitables.get("configSource").remove(this.configSource);
    if (configSource!=null){ this.configSource= new io.fabric8.kubernetes.api.model.NodeConfigSourceBuilder(configSource); _visitables.get("configSource").add(this.configSource);} return (A) this;
  }
  public java.lang.Boolean hasConfigSource() {
    return this.configSource != null;
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.ConfigSourceNested<A> withNewConfigSource() {
    return new io.fabric8.kubernetes.api.model.NodeSpecFluentImpl.ConfigSourceNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.ConfigSourceNested<A> withNewConfigSourceLike(io.fabric8.kubernetes.api.model.NodeConfigSource item) {
    return new io.fabric8.kubernetes.api.model.NodeSpecFluentImpl.ConfigSourceNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.ConfigSourceNested<A> editConfigSource() {
    return withNewConfigSourceLike(getConfigSource());
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSource() {
    return withNewConfigSourceLike(getConfigSource() != null ? getConfigSource(): new io.fabric8.kubernetes.api.model.NodeConfigSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSourceLike(io.fabric8.kubernetes.api.model.NodeConfigSource item) {
    return withNewConfigSourceLike(getConfigSource() != null ? getConfigSource(): item);
  }
  public java.lang.String getExternalID() {
    return this.externalID;
  }
  public A withExternalID(java.lang.String externalID) {
    this.externalID=externalID; return (A) this;
  }
  public java.lang.Boolean hasExternalID() {
    return this.externalID != null;
  }
  
  /**
   * Method is deprecated. use withExternalID instead.
   */
  @java.lang.Deprecated
  public A withNewExternalID(java.lang.String arg0) {
    return (A)withExternalID(new String(arg0));
  }
  public java.lang.String getPodCIDR() {
    return this.podCIDR;
  }
  public A withPodCIDR(java.lang.String podCIDR) {
    this.podCIDR=podCIDR; return (A) this;
  }
  public java.lang.Boolean hasPodCIDR() {
    return this.podCIDR != null;
  }
  
  /**
   * Method is deprecated. use withPodCIDR instead.
   */
  @java.lang.Deprecated
  public A withNewPodCIDR(java.lang.String arg0) {
    return (A)withPodCIDR(new String(arg0));
  }
  public A addToPodCIDRs(java.lang.Integer index,java.lang.String item) {
    if (this.podCIDRs == null) {this.podCIDRs = new java.util.ArrayList<java.lang.String>();}
    this.podCIDRs.add(index, item);
    return (A)this;
  }
  public A setToPodCIDRs(java.lang.Integer index,java.lang.String item) {
    if (this.podCIDRs == null) {this.podCIDRs = new java.util.ArrayList<java.lang.String>();}
    this.podCIDRs.set(index, item); return (A)this;
  }
  public A addToPodCIDRs(java.lang.String... items) {
    if (this.podCIDRs == null) {this.podCIDRs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.podCIDRs.add(item);} return (A)this;
  }
  public A addAllToPodCIDRs(java.util.Collection<java.lang.String> items) {
    if (this.podCIDRs == null) {this.podCIDRs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.podCIDRs.add(item);} return (A)this;
  }
  public A removeFromPodCIDRs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.podCIDRs!= null){ this.podCIDRs.remove(item);}} return (A)this;
  }
  public A removeAllFromPodCIDRs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.podCIDRs!= null){ this.podCIDRs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getPodCIDRs() {
    return this.podCIDRs;
  }
  public java.lang.String getPodCIDR(java.lang.Integer index) {
    return this.podCIDRs.get(index);
  }
  public java.lang.String getFirstPodCIDR() {
    return this.podCIDRs.get(0);
  }
  public java.lang.String getLastPodCIDR() {
    return this.podCIDRs.get(podCIDRs.size() - 1);
  }
  public java.lang.String getMatchingPodCIDR(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: podCIDRs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingPodCIDR(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: podCIDRs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPodCIDRs(java.util.List<java.lang.String> podCIDRs) {
    if (podCIDRs != null) {this.podCIDRs = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : podCIDRs){this.addToPodCIDRs(item);}} else { this.podCIDRs = null;} return (A) this;
  }
  public A withPodCIDRs(java.lang.String... podCIDRs) {
    if (this.podCIDRs != null) {this.podCIDRs.clear();}
    if (podCIDRs != null) {for (java.lang.String item :podCIDRs){ this.addToPodCIDRs(item);}} return (A) this;
  }
  public java.lang.Boolean hasPodCIDRs() {
    return podCIDRs != null && !podCIDRs.isEmpty();
  }
  public A addNewPodCIDR(java.lang.String arg0) {
    return (A)addToPodCIDRs(new String(arg0));
  }
  public java.lang.String getProviderID() {
    return this.providerID;
  }
  public A withProviderID(java.lang.String providerID) {
    this.providerID=providerID; return (A) this;
  }
  public java.lang.Boolean hasProviderID() {
    return this.providerID != null;
  }
  
  /**
   * Method is deprecated. use withProviderID instead.
   */
  @java.lang.Deprecated
  public A withNewProviderID(java.lang.String arg0) {
    return (A)withProviderID(new String(arg0));
  }
  public A addToTaints(java.lang.Integer index,io.fabric8.kubernetes.api.model.Taint item) {
    if (this.taints == null) {this.taints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TaintBuilder>();}
    io.fabric8.kubernetes.api.model.TaintBuilder builder = new io.fabric8.kubernetes.api.model.TaintBuilder(item);_visitables.get("taints").add(index >= 0 ? index : _visitables.get("taints").size(), builder);this.taints.add(index >= 0 ? index : taints.size(), builder); return (A)this;
  }
  public A setToTaints(java.lang.Integer index,io.fabric8.kubernetes.api.model.Taint item) {
    if (this.taints == null) {this.taints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TaintBuilder>();}
    io.fabric8.kubernetes.api.model.TaintBuilder builder = new io.fabric8.kubernetes.api.model.TaintBuilder(item);
    if (index < 0 || index >= _visitables.get("taints").size()) { _visitables.get("taints").add(builder); } else { _visitables.get("taints").set(index, builder);}
    if (index < 0 || index >= taints.size()) { taints.add(builder); } else { taints.set(index, builder);}
     return (A)this;
  }
  public A addToTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    if (this.taints == null) {this.taints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TaintBuilder>();}
    for (io.fabric8.kubernetes.api.model.Taint item : items) {io.fabric8.kubernetes.api.model.TaintBuilder builder = new io.fabric8.kubernetes.api.model.TaintBuilder(item);_visitables.get("taints").add(builder);this.taints.add(builder);} return (A)this;
  }
  public A addAllToTaints(java.util.Collection<io.fabric8.kubernetes.api.model.Taint> items) {
    if (this.taints == null) {this.taints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TaintBuilder>();}
    for (io.fabric8.kubernetes.api.model.Taint item : items) {io.fabric8.kubernetes.api.model.TaintBuilder builder = new io.fabric8.kubernetes.api.model.TaintBuilder(item);_visitables.get("taints").add(builder);this.taints.add(builder);} return (A)this;
  }
  public A removeFromTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    for (io.fabric8.kubernetes.api.model.Taint item : items) {io.fabric8.kubernetes.api.model.TaintBuilder builder = new io.fabric8.kubernetes.api.model.TaintBuilder(item);_visitables.get("taints").remove(builder);if (this.taints != null) {this.taints.remove(builder);}} return (A)this;
  }
  public A removeAllFromTaints(java.util.Collection<io.fabric8.kubernetes.api.model.Taint> items) {
    for (io.fabric8.kubernetes.api.model.Taint item : items) {io.fabric8.kubernetes.api.model.TaintBuilder builder = new io.fabric8.kubernetes.api.model.TaintBuilder(item);_visitables.get("taints").remove(builder);if (this.taints != null) {this.taints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTaints(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TaintBuilder> predicate) {
    if (taints == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.TaintBuilder> each = taints.iterator();
    final List visitables = _visitables.get("taints");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.TaintBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTaints instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Taint> getTaints() {
    return build(taints);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Taint> buildTaints() {
    return build(taints);
  }
  public io.fabric8.kubernetes.api.model.Taint buildTaint(java.lang.Integer index) {
    return this.taints.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.Taint buildFirstTaint() {
    return this.taints.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.Taint buildLastTaint() {
    return this.taints.get(taints.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.Taint buildMatchingTaint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TaintBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.TaintBuilder item: taints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingTaint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TaintBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.TaintBuilder item: taints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTaints(java.util.List<io.fabric8.kubernetes.api.model.Taint> taints) {
    if (this.taints != null) { _visitables.get("taints").removeAll(this.taints);}
    if (taints != null) {this.taints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TaintBuilder>(); for (io.fabric8.kubernetes.api.model.Taint item : taints){this.addToTaints(item);}} else { this.taints = null;} return (A) this;
  }
  public A withTaints(io.fabric8.kubernetes.api.model.Taint... taints) {
    if (this.taints != null) {this.taints.clear();}
    if (taints != null) {for (io.fabric8.kubernetes.api.model.Taint item :taints){ this.addToTaints(item);}} return (A) this;
  }
  public java.lang.Boolean hasTaints() {
    return taints != null && !taints.isEmpty();
  }
  public A addNewTaint(java.lang.String effect,java.lang.String key,java.lang.String timeAdded,java.lang.String value) {
    return (A)addToTaints(new Taint(effect, key, timeAdded, value));
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.TaintsNested<A> addNewTaint() {
    return new io.fabric8.kubernetes.api.model.NodeSpecFluentImpl.TaintsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.TaintsNested<A> addNewTaintLike(io.fabric8.kubernetes.api.model.Taint item) {
    return new io.fabric8.kubernetes.api.model.NodeSpecFluentImpl.TaintsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.TaintsNested<A> setNewTaintLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Taint item) {
    return new io.fabric8.kubernetes.api.model.NodeSpecFluentImpl.TaintsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.TaintsNested<A> editTaint(java.lang.Integer index) {
    if (taints.size() <= index) throw new RuntimeException("Can't edit taints. Index exceeds size.");
    return setNewTaintLike(index, buildTaint(index));
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.TaintsNested<A> editFirstTaint() {
    if (taints.size() == 0) throw new RuntimeException("Can't edit first taints. The list is empty.");
    return setNewTaintLike(0, buildTaint(0));
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.TaintsNested<A> editLastTaint() {
    int index = taints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last taints. The list is empty.");
    return setNewTaintLike(index, buildTaint(index));
  }
  public io.fabric8.kubernetes.api.model.NodeSpecFluent.TaintsNested<A> editMatchingTaint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TaintBuilder> predicate) {
    int index = -1;
    for (int i=0;i<taints.size();i++) { 
    if (predicate.test(taints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching taints. No match found.");
    return setNewTaintLike(index, buildTaint(index));
  }
  public java.lang.Boolean getUnschedulable() {
    return this.unschedulable;
  }
  public A withUnschedulable(java.lang.Boolean unschedulable) {
    this.unschedulable=unschedulable; return (A) this;
  }
  public java.lang.Boolean hasUnschedulable() {
    return this.unschedulable != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NodeSpecFluentImpl that = (NodeSpecFluentImpl) o;
    if (configSource != null ? !configSource.equals(that.configSource) :that.configSource != null) return false;
    if (externalID != null ? !externalID.equals(that.externalID) :that.externalID != null) return false;
    if (podCIDR != null ? !podCIDR.equals(that.podCIDR) :that.podCIDR != null) return false;
    if (podCIDRs != null ? !podCIDRs.equals(that.podCIDRs) :that.podCIDRs != null) return false;
    if (providerID != null ? !providerID.equals(that.providerID) :that.providerID != null) return false;
    if (taints != null ? !taints.equals(that.taints) :that.taints != null) return false;
    if (unschedulable != null ? !unschedulable.equals(that.unschedulable) :that.unschedulable != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configSource,  externalID,  podCIDR,  podCIDRs,  providerID,  taints,  unschedulable,  additionalProperties,  super.hashCode());
  }
  public class ConfigSourceNestedImpl<N> extends io.fabric8.kubernetes.api.model.NodeConfigSourceFluentImpl<io.fabric8.kubernetes.api.model.NodeSpecFluent.ConfigSourceNested<N>> implements io.fabric8.kubernetes.api.model.NodeSpecFluent.ConfigSourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConfigSourceNestedImpl(io.fabric8.kubernetes.api.model.NodeConfigSource item) {
      this.builder = new io.fabric8.kubernetes.api.model.NodeConfigSourceBuilder(this, item);
    }
    ConfigSourceNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.NodeConfigSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NodeConfigSourceBuilder builder;
    public N and() {
      return (N) NodeSpecFluentImpl.this.withConfigSource(builder.build());
    }
    public N endConfigSource() {
      return and();
    }
    
  }
  public class TaintsNestedImpl<N> extends io.fabric8.kubernetes.api.model.TaintFluentImpl<io.fabric8.kubernetes.api.model.NodeSpecFluent.TaintsNested<N>> implements io.fabric8.kubernetes.api.model.NodeSpecFluent.TaintsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TaintsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Taint item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.TaintBuilder(this, item);
    }
    TaintsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.TaintBuilder(this);
    }
    io.fabric8.kubernetes.api.model.TaintBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NodeSpecFluentImpl.this.setToTaints(index,builder.build());
    }
    public N endTaint() {
      return and();
    }
    
  }
  
}