package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class EndpointsListFluentImpl<A extends io.fabric8.kubernetes.api.model.EndpointsListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.EndpointsListFluent<A>{
  public EndpointsListFluentImpl() {
  }
  public EndpointsListFluentImpl(io.fabric8.kubernetes.api.model.EndpointsList instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private java.util.List<io.fabric8.kubernetes.api.model.EndpointsBuilder> items =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointsBuilder>();
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ListMetaBuilder metadata;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public A addToItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Endpoints item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointsBuilder>();}
    io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToItems(java.lang.Integer index,io.fabric8.kubernetes.api.model.Endpoints item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointsBuilder>();}
    io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToItems(io.fabric8.kubernetes.api.model.Endpoints... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointsBuilder>();}
    for (io.fabric8.kubernetes.api.model.Endpoints item : items) {io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(java.util.Collection<io.fabric8.kubernetes.api.model.Endpoints> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointsBuilder>();}
    for (io.fabric8.kubernetes.api.model.Endpoints item : items) {io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.kubernetes.api.model.Endpoints... items) {
    for (io.fabric8.kubernetes.api.model.Endpoints item : items) {io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(java.util.Collection<io.fabric8.kubernetes.api.model.Endpoints> items) {
    for (io.fabric8.kubernetes.api.model.Endpoints item : items) {io.fabric8.kubernetes.api.model.EndpointsBuilder builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointsBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.EndpointsBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.EndpointsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Endpoints> getItems() {
    return build(items);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.Endpoints> buildItems() {
    return build(items);
  }
  public io.fabric8.kubernetes.api.model.Endpoints buildItem(java.lang.Integer index) {
    return this.items.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.Endpoints buildFirstItem() {
    return this.items.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.Endpoints buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.Endpoints buildMatchingItem(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointsBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.EndpointsBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingItem(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointsBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.EndpointsBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(java.util.List<io.fabric8.kubernetes.api.model.Endpoints> items) {
    if (this.items != null) { _visitables.get("items").removeAll(this.items);}
    if (items != null) {this.items = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointsBuilder>(); for (io.fabric8.kubernetes.api.model.Endpoints item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.kubernetes.api.model.Endpoints... items) {
    if (this.items != null) {this.items.clear();}
    if (items != null) {for (io.fabric8.kubernetes.api.model.Endpoints item :items){ this.addToItems(item);}} return (A) this;
  }
  public java.lang.Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.ItemsNested<A> addNewItem() {
    return new io.fabric8.kubernetes.api.model.EndpointsListFluentImpl.ItemsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.ItemsNested<A> addNewItemLike(io.fabric8.kubernetes.api.model.Endpoints item) {
    return new io.fabric8.kubernetes.api.model.EndpointsListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.ItemsNested<A> setNewItemLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Endpoints item) {
    return new io.fabric8.kubernetes.api.model.EndpointsListFluentImpl.ItemsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.ItemsNested<A> editItem(java.lang.Integer index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.ItemsNested<A> editMatchingItem(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ListMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ListMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ListMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(java.lang.String _continue,java.lang.Long remainingItemCount,java.lang.String resourceVersion,java.lang.String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.kubernetes.api.model.EndpointsListFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ListMeta item) {
    return new io.fabric8.kubernetes.api.model.EndpointsListFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ListMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.EndpointsListFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ListMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointsListFluentImpl that = (EndpointsListFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (items != null ? !items.equals(that.items) :that.items != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public class ItemsNestedImpl<N> extends io.fabric8.kubernetes.api.model.EndpointsFluentImpl<io.fabric8.kubernetes.api.model.EndpointsListFluent.ItemsNested<N>> implements io.fabric8.kubernetes.api.model.EndpointsListFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ItemsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.Endpoints item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EndpointsBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) EndpointsListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ListMetaFluentImpl<io.fabric8.kubernetes.api.model.EndpointsListFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.EndpointsListFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ListMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ListMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ListMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ListMetaBuilder builder;
    public N and() {
      return (N) EndpointsListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}