package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class LoadBalancerStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<A>{
  public LoadBalancerStatusFluentImpl() {
  }
  public LoadBalancerStatusFluentImpl(io.fabric8.kubernetes.api.model.LoadBalancerStatus instance) {
    this.withIngress(instance.getIngress()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder> ingress =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToIngress(java.lang.Integer index,io.fabric8.kubernetes.api.model.LoadBalancerIngress item) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder>();}
    io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder builder = new io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder(item);_visitables.get("ingress").add(index >= 0 ? index : _visitables.get("ingress").size(), builder);this.ingress.add(index >= 0 ? index : ingress.size(), builder); return (A)this;
  }
  public A setToIngress(java.lang.Integer index,io.fabric8.kubernetes.api.model.LoadBalancerIngress item) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder>();}
    io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder builder = new io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder(item);
    if (index < 0 || index >= _visitables.get("ingress").size()) { _visitables.get("ingress").add(builder); } else { _visitables.get("ingress").set(index, builder);}
    if (index < 0 || index >= ingress.size()) { ingress.add(builder); } else { ingress.set(index, builder);}
     return (A)this;
  }
  public A addToIngress(io.fabric8.kubernetes.api.model.LoadBalancerIngress... items) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder>();}
    for (io.fabric8.kubernetes.api.model.LoadBalancerIngress item : items) {io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder builder = new io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  public A addAllToIngress(java.util.Collection<io.fabric8.kubernetes.api.model.LoadBalancerIngress> items) {
    if (this.ingress == null) {this.ingress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder>();}
    for (io.fabric8.kubernetes.api.model.LoadBalancerIngress item : items) {io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder builder = new io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  public A removeFromIngress(io.fabric8.kubernetes.api.model.LoadBalancerIngress... items) {
    for (io.fabric8.kubernetes.api.model.LoadBalancerIngress item : items) {io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder builder = new io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
  }
  public A removeAllFromIngress(java.util.Collection<io.fabric8.kubernetes.api.model.LoadBalancerIngress> items) {
    for (io.fabric8.kubernetes.api.model.LoadBalancerIngress item : items) {io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder builder = new io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIngress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder> predicate) {
    if (ingress == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder> each = ingress.iterator();
    final List visitables = _visitables.get("ingress");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildIngress instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.LoadBalancerIngress> getIngress() {
    return build(ingress);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.LoadBalancerIngress> buildIngress() {
    return build(ingress);
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerIngress buildIngress(java.lang.Integer index) {
    return this.ingress.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerIngress buildFirstIngress() {
    return this.ingress.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerIngress buildLastIngress() {
    return this.ingress.get(ingress.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerIngress buildMatchingIngress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder item: ingress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingIngress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder item: ingress) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIngress(java.util.List<io.fabric8.kubernetes.api.model.LoadBalancerIngress> ingress) {
    if (this.ingress != null) { _visitables.get("ingress").removeAll(this.ingress);}
    if (ingress != null) {this.ingress = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder>(); for (io.fabric8.kubernetes.api.model.LoadBalancerIngress item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
  }
  public A withIngress(io.fabric8.kubernetes.api.model.LoadBalancerIngress... ingress) {
    if (this.ingress != null) {this.ingress.clear();}
    if (ingress != null) {for (io.fabric8.kubernetes.api.model.LoadBalancerIngress item :ingress){ this.addToIngress(item);}} return (A) this;
  }
  public java.lang.Boolean hasIngress() {
    return ingress != null && !ingress.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent.IngressNested<A> addNewIngress() {
    return new io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentImpl.IngressNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent.IngressNested<A> addNewIngressLike(io.fabric8.kubernetes.api.model.LoadBalancerIngress item) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentImpl.IngressNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent.IngressNested<A> setNewIngressLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.LoadBalancerIngress item) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentImpl.IngressNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent.IngressNested<A> editIngress(java.lang.Integer index) {
    if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent.IngressNested<A> editFirstIngress() {
    if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
    return setNewIngressLike(0, buildIngress(0));
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent.IngressNested<A> editLastIngress() {
    int index = ingress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent.IngressNested<A> editMatchingIngress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ingress.size();i++) { 
    if (predicate.test(ingress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LoadBalancerStatusFluentImpl that = (LoadBalancerStatusFluentImpl) o;
    if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ingress,  additionalProperties,  super.hashCode());
  }
  public class IngressNestedImpl<N> extends io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentImpl<io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent.IngressNested<N>> implements io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent.IngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IngressNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.LoadBalancerIngress item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder(this, item);
    }
    IngressNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) LoadBalancerStatusFluentImpl.this.setToIngress(index,builder.build());
    }
    public N endIngress() {
      return and();
    }
    
  }
  
}