package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class HTTPGetActionFluentImpl<A extends io.fabric8.kubernetes.api.model.HTTPGetActionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.HTTPGetActionFluent<A>{
  public HTTPGetActionFluentImpl() {
  }
  public HTTPGetActionFluentImpl(io.fabric8.kubernetes.api.model.HTTPGetAction instance) {
    this.withHost(instance.getHost()); 
    this.withHttpHeaders(instance.getHttpHeaders()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withScheme(instance.getScheme()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String host;
  private java.util.List<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder> httpHeaders =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder>();
  private java.lang.String path;
  private io.fabric8.kubernetes.api.model.IntOrStringBuilder port;
  private java.lang.String scheme;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getHost() {
    return this.host;
  }
  public A withHost(java.lang.String host) {
    this.host=host; return (A) this;
  }
  public java.lang.Boolean hasHost() {
    return this.host != null;
  }
  
  /**
   * Method is deprecated. use withHost instead.
   */
  @java.lang.Deprecated
  public A withNewHost(java.lang.String arg0) {
    return (A)withHost(new String(arg0));
  }
  public A addToHttpHeaders(java.lang.Integer index,io.fabric8.kubernetes.api.model.HTTPHeader item) {
    if (this.httpHeaders == null) {this.httpHeaders = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder>();}
    io.fabric8.kubernetes.api.model.HTTPHeaderBuilder builder = new io.fabric8.kubernetes.api.model.HTTPHeaderBuilder(item);_visitables.get("httpHeaders").add(index >= 0 ? index : _visitables.get("httpHeaders").size(), builder);this.httpHeaders.add(index >= 0 ? index : httpHeaders.size(), builder); return (A)this;
  }
  public A setToHttpHeaders(java.lang.Integer index,io.fabric8.kubernetes.api.model.HTTPHeader item) {
    if (this.httpHeaders == null) {this.httpHeaders = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder>();}
    io.fabric8.kubernetes.api.model.HTTPHeaderBuilder builder = new io.fabric8.kubernetes.api.model.HTTPHeaderBuilder(item);
    if (index < 0 || index >= _visitables.get("httpHeaders").size()) { _visitables.get("httpHeaders").add(builder); } else { _visitables.get("httpHeaders").set(index, builder);}
    if (index < 0 || index >= httpHeaders.size()) { httpHeaders.add(builder); } else { httpHeaders.set(index, builder);}
     return (A)this;
  }
  public A addToHttpHeaders(io.fabric8.kubernetes.api.model.HTTPHeader... items) {
    if (this.httpHeaders == null) {this.httpHeaders = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder>();}
    for (io.fabric8.kubernetes.api.model.HTTPHeader item : items) {io.fabric8.kubernetes.api.model.HTTPHeaderBuilder builder = new io.fabric8.kubernetes.api.model.HTTPHeaderBuilder(item);_visitables.get("httpHeaders").add(builder);this.httpHeaders.add(builder);} return (A)this;
  }
  public A addAllToHttpHeaders(java.util.Collection<io.fabric8.kubernetes.api.model.HTTPHeader> items) {
    if (this.httpHeaders == null) {this.httpHeaders = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder>();}
    for (io.fabric8.kubernetes.api.model.HTTPHeader item : items) {io.fabric8.kubernetes.api.model.HTTPHeaderBuilder builder = new io.fabric8.kubernetes.api.model.HTTPHeaderBuilder(item);_visitables.get("httpHeaders").add(builder);this.httpHeaders.add(builder);} return (A)this;
  }
  public A removeFromHttpHeaders(io.fabric8.kubernetes.api.model.HTTPHeader... items) {
    for (io.fabric8.kubernetes.api.model.HTTPHeader item : items) {io.fabric8.kubernetes.api.model.HTTPHeaderBuilder builder = new io.fabric8.kubernetes.api.model.HTTPHeaderBuilder(item);_visitables.get("httpHeaders").remove(builder);if (this.httpHeaders != null) {this.httpHeaders.remove(builder);}} return (A)this;
  }
  public A removeAllFromHttpHeaders(java.util.Collection<io.fabric8.kubernetes.api.model.HTTPHeader> items) {
    for (io.fabric8.kubernetes.api.model.HTTPHeader item : items) {io.fabric8.kubernetes.api.model.HTTPHeaderBuilder builder = new io.fabric8.kubernetes.api.model.HTTPHeaderBuilder(item);_visitables.get("httpHeaders").remove(builder);if (this.httpHeaders != null) {this.httpHeaders.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHttpHeaders(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder> predicate) {
    if (httpHeaders == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder> each = httpHeaders.iterator();
    final List visitables = _visitables.get("httpHeaders");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.HTTPHeaderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHttpHeaders instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.HTTPHeader> getHttpHeaders() {
    return build(httpHeaders);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.HTTPHeader> buildHttpHeaders() {
    return build(httpHeaders);
  }
  public io.fabric8.kubernetes.api.model.HTTPHeader buildHttpHeader(java.lang.Integer index) {
    return this.httpHeaders.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.HTTPHeader buildFirstHttpHeader() {
    return this.httpHeaders.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.HTTPHeader buildLastHttpHeader() {
    return this.httpHeaders.get(httpHeaders.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.HTTPHeader buildMatchingHttpHeader(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.HTTPHeaderBuilder item: httpHeaders) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingHttpHeader(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.HTTPHeaderBuilder item: httpHeaders) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHttpHeaders(java.util.List<io.fabric8.kubernetes.api.model.HTTPHeader> httpHeaders) {
    if (this.httpHeaders != null) { _visitables.get("httpHeaders").removeAll(this.httpHeaders);}
    if (httpHeaders != null) {this.httpHeaders = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder>(); for (io.fabric8.kubernetes.api.model.HTTPHeader item : httpHeaders){this.addToHttpHeaders(item);}} else { this.httpHeaders = null;} return (A) this;
  }
  public A withHttpHeaders(io.fabric8.kubernetes.api.model.HTTPHeader... httpHeaders) {
    if (this.httpHeaders != null) {this.httpHeaders.clear();}
    if (httpHeaders != null) {for (io.fabric8.kubernetes.api.model.HTTPHeader item :httpHeaders){ this.addToHttpHeaders(item);}} return (A) this;
  }
  public java.lang.Boolean hasHttpHeaders() {
    return httpHeaders != null && !httpHeaders.isEmpty();
  }
  public A addNewHttpHeader(java.lang.String name,java.lang.String value) {
    return (A)addToHttpHeaders(new HTTPHeader(name, value));
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeader() {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionFluentImpl.HttpHeadersNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeaderLike(io.fabric8.kubernetes.api.model.HTTPHeader item) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionFluentImpl.HttpHeadersNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.HttpHeadersNested<A> setNewHttpHeaderLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.HTTPHeader item) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionFluentImpl.HttpHeadersNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.HttpHeadersNested<A> editHttpHeader(java.lang.Integer index) {
    if (httpHeaders.size() <= index) throw new RuntimeException("Can't edit httpHeaders. Index exceeds size.");
    return setNewHttpHeaderLike(index, buildHttpHeader(index));
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.HttpHeadersNested<A> editFirstHttpHeader() {
    if (httpHeaders.size() == 0) throw new RuntimeException("Can't edit first httpHeaders. The list is empty.");
    return setNewHttpHeaderLike(0, buildHttpHeader(0));
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.HttpHeadersNested<A> editLastHttpHeader() {
    int index = httpHeaders.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last httpHeaders. The list is empty.");
    return setNewHttpHeaderLike(index, buildHttpHeader(index));
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.HttpHeadersNested<A> editMatchingHttpHeader(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HTTPHeaderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<httpHeaders.size();i++) { 
    if (predicate.test(httpHeaders.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching httpHeaders. No match found.");
    return setNewHttpHeaderLike(index, buildHttpHeader(index));
  }
  public java.lang.String getPath() {
    return this.path;
  }
  public A withPath(java.lang.String path) {
    this.path=path; return (A) this;
  }
  public java.lang.Boolean hasPath() {
    return this.path != null;
  }
  
  /**
   * Method is deprecated. use withPath instead.
   */
  @java.lang.Deprecated
  public A withNewPath(java.lang.String arg0) {
    return (A)withPath(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.IntOrString getPort() {
    return this.port!=null?this.port.build():null;
  }
  public io.fabric8.kubernetes.api.model.IntOrString buildPort() {
    return this.port!=null?this.port.build():null;
  }
  public A withPort(io.fabric8.kubernetes.api.model.IntOrString port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new io.fabric8.kubernetes.api.model.IntOrStringBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
  }
  public java.lang.Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(java.lang.Integer intVal) {
    return (A)withPort(new IntOrString(intVal));
  }
  public A withNewPort(java.lang.String strVal) {
    return (A)withPort(new IntOrString(strVal));
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.PortNested<A> withNewPort() {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionFluentImpl.PortNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.PortNested<A> withNewPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionFluentImpl.PortNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.HTTPGetActionFluent.PortNested<A> editOrNewPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  public java.lang.String getScheme() {
    return this.scheme;
  }
  public A withScheme(java.lang.String scheme) {
    this.scheme=scheme; return (A) this;
  }
  public java.lang.Boolean hasScheme() {
    return this.scheme != null;
  }
  
  /**
   * Method is deprecated. use withScheme instead.
   */
  @java.lang.Deprecated
  public A withNewScheme(java.lang.String arg0) {
    return (A)withScheme(new String(arg0));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPGetActionFluentImpl that = (HTTPGetActionFluentImpl) o;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (httpHeaders != null ? !httpHeaders.equals(that.httpHeaders) :that.httpHeaders != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  httpHeaders,  path,  port,  scheme,  additionalProperties,  super.hashCode());
  }
  public class HttpHeadersNestedImpl<N> extends io.fabric8.kubernetes.api.model.HTTPHeaderFluentImpl<io.fabric8.kubernetes.api.model.HTTPGetActionFluent.HttpHeadersNested<N>> implements io.fabric8.kubernetes.api.model.HTTPGetActionFluent.HttpHeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HttpHeadersNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.HTTPHeader item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.HTTPHeaderBuilder(this, item);
    }
    HttpHeadersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.HTTPHeaderBuilder(this);
    }
    io.fabric8.kubernetes.api.model.HTTPHeaderBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) HTTPGetActionFluentImpl.this.setToHttpHeaders(index,builder.build());
    }
    public N endHttpHeader() {
      return and();
    }
    
  }
  public class PortNestedImpl<N> extends io.fabric8.kubernetes.api.model.IntOrStringFluentImpl<io.fabric8.kubernetes.api.model.HTTPGetActionFluent.PortNested<N>> implements io.fabric8.kubernetes.api.model.HTTPGetActionFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PortNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
      this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
    }
    io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;
    public N and() {
      return (N) HTTPGetActionFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}