package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ContainerStatusBuilder extends io.fabric8.kubernetes.api.model.ContainerStatusFluentImpl<io.fabric8.kubernetes.api.model.ContainerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ContainerStatus,io.fabric8.kubernetes.api.model.ContainerStatusBuilder>{
  public ContainerStatusBuilder() {
    this(false);
  }
  public ContainerStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new ContainerStatus(), validationEnabled);
  }
  public ContainerStatusBuilder(io.fabric8.kubernetes.api.model.ContainerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStatusBuilder(io.fabric8.kubernetes.api.model.ContainerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerStatus(), validationEnabled);
  }
  public ContainerStatusBuilder(io.fabric8.kubernetes.api.model.ContainerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerStatus instance) {
    this(fluent, instance, false);
  }
  public ContainerStatusBuilder(io.fabric8.kubernetes.api.model.ContainerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainerID(instance.getContainerID()); 
    fluent.withImage(instance.getImage()); 
    fluent.withImageID(instance.getImageID()); 
    fluent.withLastState(instance.getLastState()); 
    fluent.withName(instance.getName()); 
    fluent.withReady(instance.getReady()); 
    fluent.withRestartCount(instance.getRestartCount()); 
    fluent.withStarted(instance.getStarted()); 
    fluent.withState(instance.getState()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerStatusBuilder(io.fabric8.kubernetes.api.model.ContainerStatus instance) {
    this(instance,false);
  }
  public ContainerStatusBuilder(io.fabric8.kubernetes.api.model.ContainerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainerID(instance.getContainerID()); 
    this.withImage(instance.getImage()); 
    this.withImageID(instance.getImageID()); 
    this.withLastState(instance.getLastState()); 
    this.withName(instance.getName()); 
    this.withReady(instance.getReady()); 
    this.withRestartCount(instance.getRestartCount()); 
    this.withStarted(instance.getStarted()); 
    this.withState(instance.getState()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ContainerStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ContainerStatus build() {
    ContainerStatus buildable = new ContainerStatus(fluent.getContainerID(),fluent.getImage(),fluent.getImageID(),fluent.getLastState(),fluent.getName(),fluent.getReady(),fluent.getRestartCount(),fluent.getStarted(),fluent.getState());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerStatusBuilder that = (ContainerStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}