package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class PodReadinessGateFluentImpl<A extends PodReadinessGateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodReadinessGateFluent<A> {

    private String conditionType;

    public PodReadinessGateFluentImpl() {
    }

    public PodReadinessGateFluentImpl(PodReadinessGate instance) {
        this.withConditionType(instance.getConditionType()); 
    }

    public String getConditionType() {
        return this.conditionType;
    }

    public A withConditionType(String conditionType) {
        this.conditionType=conditionType; return (A) this;
    }

    public Boolean hasConditionType() {
        return this.conditionType != null;
    }

    public A withNewConditionType(String arg1) {
        return (A)withConditionType(new String(arg1));
    }

    public A withNewConditionType(StringBuilder arg1) {
        return (A)withConditionType(new String(arg1));
    }

    public A withNewConditionType(StringBuffer arg1) {
        return (A)withConditionType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodReadinessGateFluentImpl that = (PodReadinessGateFluentImpl) o;
        if (conditionType != null ? !conditionType.equals(that.conditionType) :that.conditionType != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditionType,  super.hashCode());
    }

}
