package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface APIServiceStatusFluent<A extends APIServiceStatusFluent<A>> extends Fluent<A> {


    public A addToConditions(int index,APIServiceCondition item);
    public A setToConditions(int index,APIServiceCondition item);
    public A addToConditions(APIServiceCondition... items);
    public A addAllToConditions(Collection<APIServiceCondition> items);
    public A removeFromConditions(APIServiceCondition... items);
    public A removeAllFromConditions(Collection<APIServiceCondition> items);
    public A removeMatchingFromConditions(Predicate<APIServiceConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<APIServiceCondition> getConditions();
    public List<APIServiceCondition> buildConditions();
    public APIServiceCondition buildCondition(int index);
    public APIServiceCondition buildFirstCondition();
    public APIServiceCondition buildLastCondition();
    public APIServiceCondition buildMatchingCondition(Predicate<APIServiceConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<APIServiceConditionBuilder> predicate);
    public A withConditions(List<APIServiceCondition> conditions);
    public A withConditions(APIServiceCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public APIServiceStatusFluent.ConditionsNested<A> addNewCondition();
    public APIServiceStatusFluent.ConditionsNested<A> addNewConditionLike(APIServiceCondition item);
    public APIServiceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,APIServiceCondition item);
    public APIServiceStatusFluent.ConditionsNested<A> editCondition(int index);
    public APIServiceStatusFluent.ConditionsNested<A> editFirstCondition();
    public APIServiceStatusFluent.ConditionsNested<A> editLastCondition();
    public APIServiceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<APIServiceConditionBuilder> predicate);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServiceConditionFluent<APIServiceStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


}
