package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceFieldSelectorBuilder extends ResourceFieldSelectorFluentImpl<ResourceFieldSelectorBuilder> implements VisitableBuilder<ResourceFieldSelector,ResourceFieldSelectorBuilder> {

    ResourceFieldSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceFieldSelectorBuilder() {
        this(true);
    }

    public ResourceFieldSelectorBuilder(Boolean validationEnabled) {
        this(new ResourceFieldSelector(), validationEnabled);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ResourceFieldSelector(), validationEnabled);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent,ResourceFieldSelector instance) {
        this(fluent, instance, true);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent,ResourceFieldSelector instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withContainerName(instance.getContainerName()); 
        fluent.withDivisor(instance.getDivisor()); 
        fluent.withResource(instance.getResource()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelector instance) {
        this(instance,true);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelector instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withContainerName(instance.getContainerName()); 
        this.withDivisor(instance.getDivisor()); 
        this.withResource(instance.getResource()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceFieldSelector build() {
        ResourceFieldSelector buildable = new ResourceFieldSelector(fluent.getContainerName(),fluent.getDivisor(),fluent.getResource());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceFieldSelectorBuilder that = (ResourceFieldSelectorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
