package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class HostAliasFluentImpl<A extends HostAliasFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HostAliasFluent<A> {

    private List<String> hostnames = new ArrayList<String>();
    private String ip;

    public HostAliasFluentImpl() { 
    }


    public HostAliasFluentImpl(HostAlias instance) { 
        this.withHostnames(instance.getHostnames()); 
        this.withIp(instance.getIp()); 
    }


    public A addToHostnames(int index,String item) {
        if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
        this.hostnames.add(index, item);
        return (A)this;
    }

    public A setToHostnames(int index,String item) {
        if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
        this.hostnames.set(index, item); return (A)this;
    }

    public A addToHostnames(String... items) {
        if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
        for (String item : items) {this.hostnames.add(item);} return (A)this;
    }

    public A addAllToHostnames(Collection<String> items) {
        if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
        for (String item : items) {this.hostnames.add(item);} return (A)this;
    }

    public A removeFromHostnames(String... items) {
        for (String item : items) {if (this.hostnames!= null){ this.hostnames.remove(item);}} return (A)this;
    }

    public A removeAllFromHostnames(Collection<String> items) {
        for (String item : items) {if (this.hostnames!= null){ this.hostnames.remove(item);}} return (A)this;
    }

    public List<String> getHostnames() {
        return this.hostnames;
    }

    public String getHostname(int index) {
        return this.hostnames.get(index);
    }

    public String getFirstHostname() {
        return this.hostnames.get(0);
    }

    public String getLastHostname() {
        return this.hostnames.get(hostnames.size() - 1);
    }

    public String getMatchingHostname(Predicate<String> predicate) {
        for (String item: hostnames) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingHostname(Predicate<String> predicate) {
        for (String item: hostnames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHostnames(List<String> hostnames) {
        if (this.hostnames != null) { _visitables.get("hostnames").removeAll(this.hostnames);}
        if (hostnames != null) {this.hostnames = new ArrayList<String>(); for (String item : hostnames){this.addToHostnames(item);}} else { this.hostnames = null;} return (A) this;
    }

    public A withHostnames(String... hostnames) {
        if (this.hostnames != null) {this.hostnames.clear();}
        if (hostnames != null) {for (String item :hostnames){ this.addToHostnames(item);}} return (A) this;
    }

    public Boolean hasHostnames() {
        return hostnames != null && !hostnames.isEmpty();
    }

    public A addNewHostname(String arg1) {
        return (A)addToHostnames(new String(arg1));
    }

    public A addNewHostname(StringBuilder arg1) {
        return (A)addToHostnames(new String(arg1));
    }

    public A addNewHostname(StringBuffer arg1) {
        return (A)addToHostnames(new String(arg1));
    }

    public String getIp() {
        return this.ip;
    }

    public A withIp(String ip) {
        this.ip=ip; return (A) this;
    }

    public Boolean hasIp() {
        return this.ip != null;
    }

    public A withNewIp(String arg1) {
        return (A)withIp(new String(arg1));
    }

    public A withNewIp(StringBuilder arg1) {
        return (A)withIp(new String(arg1));
    }

    public A withNewIp(StringBuffer arg1) {
        return (A)withIp(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HostAliasFluentImpl that = (HostAliasFluentImpl) o;
        if (hostnames != null ? !hostnames.equals(that.hostnames) :that.hostnames != null) return false;
        if (ip != null ? !ip.equals(that.ip) :that.ip != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(hostnames,  ip,  super.hashCode());
    }

}
