package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ContextFluent<A extends ContextFluent<A>> extends Fluent<A> {


    public String getCluster();
    public A withCluster(String cluster);
    public Boolean hasCluster();
    public A withNewCluster(String arg1);
    public A withNewCluster(StringBuilder arg1);
    public A withNewCluster(StringBuffer arg1);
    public A addToExtensions(int index,NamedExtension item);
    public A setToExtensions(int index,NamedExtension item);
    public A addToExtensions(NamedExtension... items);
    public A addAllToExtensions(Collection<NamedExtension> items);
    public A removeFromExtensions(NamedExtension... items);
    public A removeAllFromExtensions(Collection<NamedExtension> items);
    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildExtensions instead.
 * @return The buildable object.
 */
@Deprecated public List<NamedExtension> getExtensions();
    public List<NamedExtension> buildExtensions();
    public NamedExtension buildExtension(int index);
    public NamedExtension buildFirstExtension();
    public NamedExtension buildLastExtension();
    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
    public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
    public A withExtensions(List<NamedExtension> extensions);
    public A withExtensions(NamedExtension... extensions);
    public Boolean hasExtensions();
    public ContextFluent.ExtensionsNested<A> addNewExtension();
    public ContextFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item);
    public ContextFluent.ExtensionsNested<A> setNewExtensionLike(int index,NamedExtension item);
    public ContextFluent.ExtensionsNested<A> editExtension(int index);
    public ContextFluent.ExtensionsNested<A> editFirstExtension();
    public ContextFluent.ExtensionsNested<A> editLastExtension();
    public ContextFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
    public String getNamespace();
    public A withNamespace(String namespace);
    public Boolean hasNamespace();
    public A withNewNamespace(String arg1);
    public A withNewNamespace(StringBuilder arg1);
    public A withNewNamespace(StringBuffer arg1);
    public String getUser();
    public A withUser(String user);
    public Boolean hasUser();
    public A withNewUser(String arg1);
    public A withNewUser(StringBuilder arg1);
    public A withNewUser(StringBuffer arg1);
    public interface ExtensionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedExtensionFluent<ContextFluent.ExtensionsNested<N>> {

        public N and();
        public N endExtension();    }


}
