package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PodSecurityContextFluent<A extends PodSecurityContextFluent<A>> extends Fluent<A> {


    public Long getFsGroup();
    public A withFsGroup(Long fsGroup);
    public Boolean hasFsGroup();
    public String getFsGroupChangePolicy();
    public A withFsGroupChangePolicy(String fsGroupChangePolicy);
    public Boolean hasFsGroupChangePolicy();
    public A withNewFsGroupChangePolicy(String arg1);
    public A withNewFsGroupChangePolicy(StringBuilder arg1);
    public A withNewFsGroupChangePolicy(StringBuffer arg1);
    public Long getRunAsGroup();
    public A withRunAsGroup(Long runAsGroup);
    public Boolean hasRunAsGroup();
    public Boolean isRunAsNonRoot();
    public A withRunAsNonRoot(Boolean runAsNonRoot);
    public Boolean hasRunAsNonRoot();
    public A withNewRunAsNonRoot(String arg1);
    public A withNewRunAsNonRoot(boolean arg1);
    public Long getRunAsUser();
    public A withRunAsUser(Long runAsUser);
    public Boolean hasRunAsUser();
    
/**
 * This method has been deprecated, please use method buildSeLinuxOptions instead.
 * @return The buildable object.
 */
@Deprecated public SELinuxOptions getSeLinuxOptions();
    public SELinuxOptions buildSeLinuxOptions();
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions);
    public Boolean hasSeLinuxOptions();
    public A withNewSeLinuxOptions(String level,String role,String type,String user);
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions();
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item);
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions();
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions();
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item);
    
/**
 * This method has been deprecated, please use method buildSeccompProfile instead.
 * @return The buildable object.
 */
@Deprecated public SeccompProfile getSeccompProfile();
    public SeccompProfile buildSeccompProfile();
    public A withSeccompProfile(SeccompProfile seccompProfile);
    public Boolean hasSeccompProfile();
    public A withNewSeccompProfile(String localhostProfile,String type);
    public PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile();
    public PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item);
    public PodSecurityContextFluent.SeccompProfileNested<A> editSeccompProfile();
    public PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile();
    public PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item);
    public A addToSupplementalGroups(int index,Long item);
    public A setToSupplementalGroups(int index,Long item);
    public A addToSupplementalGroups(Long... items);
    public A addAllToSupplementalGroups(Collection<Long> items);
    public A removeFromSupplementalGroups(Long... items);
    public A removeAllFromSupplementalGroups(Collection<Long> items);
    public List<Long> getSupplementalGroups();
    public Long getSupplementalGroup(int index);
    public Long getFirstSupplementalGroup();
    public Long getLastSupplementalGroup();
    public Long getMatchingSupplementalGroup(Predicate<Long> predicate);
    public Boolean hasMatchingSupplementalGroup(Predicate<Long> predicate);
    public A withSupplementalGroups(List<Long> supplementalGroups);
    public A withSupplementalGroups(Long... supplementalGroups);
    public Boolean hasSupplementalGroups();
    public A addToSysctls(int index,Sysctl item);
    public A setToSysctls(int index,Sysctl item);
    public A addToSysctls(Sysctl... items);
    public A addAllToSysctls(Collection<Sysctl> items);
    public A removeFromSysctls(Sysctl... items);
    public A removeAllFromSysctls(Collection<Sysctl> items);
    public A removeMatchingFromSysctls(Predicate<SysctlBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSysctls instead.
 * @return The buildable object.
 */
@Deprecated public List<Sysctl> getSysctls();
    public List<Sysctl> buildSysctls();
    public Sysctl buildSysctl(int index);
    public Sysctl buildFirstSysctl();
    public Sysctl buildLastSysctl();
    public Sysctl buildMatchingSysctl(Predicate<SysctlBuilder> predicate);
    public Boolean hasMatchingSysctl(Predicate<SysctlBuilder> predicate);
    public A withSysctls(List<Sysctl> sysctls);
    public A withSysctls(Sysctl... sysctls);
    public Boolean hasSysctls();
    public A addNewSysctl(String name,String value);
    public PodSecurityContextFluent.SysctlsNested<A> addNewSysctl();
    public PodSecurityContextFluent.SysctlsNested<A> addNewSysctlLike(Sysctl item);
    public PodSecurityContextFluent.SysctlsNested<A> setNewSysctlLike(int index,Sysctl item);
    public PodSecurityContextFluent.SysctlsNested<A> editSysctl(int index);
    public PodSecurityContextFluent.SysctlsNested<A> editFirstSysctl();
    public PodSecurityContextFluent.SysctlsNested<A> editLastSysctl();
    public PodSecurityContextFluent.SysctlsNested<A> editMatchingSysctl(Predicate<SysctlBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildWindowsOptions instead.
 * @return The buildable object.
 */
@Deprecated public WindowsSecurityContextOptions getWindowsOptions();
    public WindowsSecurityContextOptions buildWindowsOptions();
    public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions);
    public Boolean hasWindowsOptions();
    public A withNewWindowsOptions(String gmsaCredentialSpec,String gmsaCredentialSpecName,String runAsUserName);
    public PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions();
    public PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item);
    public PodSecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions();
    public PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions();
    public PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item);
    public interface SeLinuxOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SELinuxOptionsFluent<PodSecurityContextFluent.SeLinuxOptionsNested<N>> {

        public N and();
        public N endSeLinuxOptions();    }


    public interface SeccompProfileNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SeccompProfileFluent<PodSecurityContextFluent.SeccompProfileNested<N>> {

        public N and();
        public N endSeccompProfile();    }


    public interface SysctlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SysctlFluent<PodSecurityContextFluent.SysctlsNested<N>> {

        public N and();
        public N endSysctl();    }


    public interface WindowsOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,WindowsSecurityContextOptionsFluent<PodSecurityContextFluent.WindowsOptionsNested<N>> {

        public N and();
        public N endWindowsOptions();    }


}
