package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PersistentVolumeClaimTemplateBuilder extends PersistentVolumeClaimTemplateFluentImpl<PersistentVolumeClaimTemplateBuilder> implements VisitableBuilder<PersistentVolumeClaimTemplate,PersistentVolumeClaimTemplateBuilder> {

    PersistentVolumeClaimTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public PersistentVolumeClaimTemplateBuilder() { 
        this(true);
    }


    public PersistentVolumeClaimTemplateBuilder(Boolean validationEnabled) { 
        this(new PersistentVolumeClaimTemplate(), validationEnabled);
    }


    public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplateFluent<?> fluent) { 
        this(fluent, true);
    }


    public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplateFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new PersistentVolumeClaimTemplate(), validationEnabled);
    }


    public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplateFluent<?> fluent,PersistentVolumeClaimTemplate instance) { 
        this(fluent, instance, true);
    }


    public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplateFluent<?> fluent,PersistentVolumeClaimTemplate instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }


    public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplate instance) { 
        this(instance,true);
    }


    public PersistentVolumeClaimTemplateBuilder(PersistentVolumeClaimTemplate instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }


    public PersistentVolumeClaimTemplate build() {
        PersistentVolumeClaimTemplate buildable = new PersistentVolumeClaimTemplate(fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PersistentVolumeClaimTemplateBuilder that = (PersistentVolumeClaimTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
