package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class APIGroupListFluentImpl<A extends APIGroupListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIGroupListFluent<A> {

    private String apiVersion;
    private List<APIGroupBuilder> groups =  new ArrayList<APIGroupBuilder>();
    private String kind;

    public APIGroupListFluentImpl() { 
    }


    public APIGroupListFluentImpl(APIGroupList instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withGroups(instance.getGroups()); 
        this.withKind(instance.getKind()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A addToGroups(int index,APIGroup item) {
        if (this.groups == null) {this.groups = new ArrayList<APIGroupBuilder>();}
        APIGroupBuilder builder = new APIGroupBuilder(item);_visitables.get("groups").add(index >= 0 ? index : _visitables.get("groups").size(), builder);this.groups.add(index >= 0 ? index : groups.size(), builder); return (A)this;
    }

    public A setToGroups(int index,APIGroup item) {
        if (this.groups == null) {this.groups = new ArrayList<APIGroupBuilder>();}
        APIGroupBuilder builder = new APIGroupBuilder(item);
        if (index < 0 || index >= _visitables.get("groups").size()) { _visitables.get("groups").add(builder); } else { _visitables.get("groups").set(index, builder);}
        if (index < 0 || index >= groups.size()) { groups.add(builder); } else { groups.set(index, builder);}
         return (A)this;
    }

    public A addToGroups(APIGroup... items) {
        if (this.groups == null) {this.groups = new ArrayList<APIGroupBuilder>();}
        for (APIGroup item : items) {APIGroupBuilder builder = new APIGroupBuilder(item);_visitables.get("groups").add(builder);this.groups.add(builder);} return (A)this;
    }

    public A addAllToGroups(Collection<APIGroup> items) {
        if (this.groups == null) {this.groups = new ArrayList<APIGroupBuilder>();}
        for (APIGroup item : items) {APIGroupBuilder builder = new APIGroupBuilder(item);_visitables.get("groups").add(builder);this.groups.add(builder);} return (A)this;
    }

    public A removeFromGroups(APIGroup... items) {
        for (APIGroup item : items) {APIGroupBuilder builder = new APIGroupBuilder(item);_visitables.get("groups").remove(builder);if (this.groups != null) {this.groups.remove(builder);}} return (A)this;
    }

    public A removeAllFromGroups(Collection<APIGroup> items) {
        for (APIGroup item : items) {APIGroupBuilder builder = new APIGroupBuilder(item);_visitables.get("groups").remove(builder);if (this.groups != null) {this.groups.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromGroups(Predicate<APIGroupBuilder> predicate) {
        if (groups == null) return (A) this;
        final Iterator<APIGroupBuilder> each = groups.iterator();
        final List visitables = _visitables.get("groups");
        while (each.hasNext()) {
          APIGroupBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildGroups instead.
 * @return The buildable object.
 */
@Deprecated public List<APIGroup> getGroups() {
        return build(groups);
    }

    public List<APIGroup> buildGroups() {
        return build(groups);
    }

    public APIGroup buildGroup(int index) {
        return this.groups.get(index).build();
    }

    public APIGroup buildFirstGroup() {
        return this.groups.get(0).build();
    }

    public APIGroup buildLastGroup() {
        return this.groups.get(groups.size() - 1).build();
    }

    public APIGroup buildMatchingGroup(Predicate<APIGroupBuilder> predicate) {
        for (APIGroupBuilder item: groups) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingGroup(Predicate<APIGroupBuilder> predicate) {
        for (APIGroupBuilder item: groups) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGroups(List<APIGroup> groups) {
        if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
        if (groups != null) {this.groups = new ArrayList<APIGroupBuilder>(); for (APIGroup item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
    }

    public A withGroups(APIGroup... groups) {
        if (this.groups != null) {this.groups.clear();}
        if (groups != null) {for (APIGroup item :groups){ this.addToGroups(item);}} return (A) this;
    }

    public Boolean hasGroups() {
        return groups != null && !groups.isEmpty();
    }

    public APIGroupListFluent.GroupsNested<A> addNewGroup() {
        return new GroupsNestedImpl();
    }

    public APIGroupListFluent.GroupsNested<A> addNewGroupLike(APIGroup item) {
        return new GroupsNestedImpl(-1, item);
    }

    public APIGroupListFluent.GroupsNested<A> setNewGroupLike(int index,APIGroup item) {
        return new GroupsNestedImpl(index, item);
    }

    public APIGroupListFluent.GroupsNested<A> editGroup(int index) {
        if (groups.size() <= index) throw new RuntimeException("Can't edit groups. Index exceeds size.");
        return setNewGroupLike(index, buildGroup(index));
    }

    public APIGroupListFluent.GroupsNested<A> editFirstGroup() {
        if (groups.size() == 0) throw new RuntimeException("Can't edit first groups. The list is empty.");
        return setNewGroupLike(0, buildGroup(0));
    }

    public APIGroupListFluent.GroupsNested<A> editLastGroup() {
        int index = groups.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last groups. The list is empty.");
        return setNewGroupLike(index, buildGroup(index));
    }

    public APIGroupListFluent.GroupsNested<A> editMatchingGroup(Predicate<APIGroupBuilder> predicate) {
        int index = -1;
        for (int i=0;i<groups.size();i++) { 
        if (predicate.test(groups.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching groups. No match found.");
        return setNewGroupLike(index, buildGroup(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIGroupListFluentImpl that = (APIGroupListFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  groups,  kind,  super.hashCode());
    }

    public class GroupsNestedImpl<N> extends APIGroupFluentImpl<APIGroupListFluent.GroupsNested<N>> implements APIGroupListFluent.GroupsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIGroupBuilder builder;
        private final int index;

        GroupsNestedImpl(int index,APIGroup item) {
            this.index = index;
            this.builder = new APIGroupBuilder(this, item);
        }

        GroupsNestedImpl() {
            this.index = -1;
            this.builder = new APIGroupBuilder(this);
        }

        public N and() {
             return (N) APIGroupListFluentImpl.this.setToGroups(index,builder.build());
        }

        public N endGroup() {
             return and();
        }
    }


}
