package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NamespaceStatusFluentImpl<A extends NamespaceStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NamespaceStatusFluent<A> {

    private List<NamespaceConditionBuilder> conditions =  new ArrayList<NamespaceConditionBuilder>();
    private String phase;

    public NamespaceStatusFluentImpl() { 
    }


    public NamespaceStatusFluentImpl(NamespaceStatus instance) { 
        this.withConditions(instance.getConditions()); 
        this.withPhase(instance.getPhase()); 
    }


    public A addToConditions(int index,NamespaceCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<NamespaceConditionBuilder>();}
        NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,NamespaceCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<NamespaceConditionBuilder>();}
        NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(NamespaceCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<NamespaceConditionBuilder>();}
        for (NamespaceCondition item : items) {NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<NamespaceCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<NamespaceConditionBuilder>();}
        for (NamespaceCondition item : items) {NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(NamespaceCondition... items) {
        for (NamespaceCondition item : items) {NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<NamespaceCondition> items) {
        for (NamespaceCondition item : items) {NamespaceConditionBuilder builder = new NamespaceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<NamespaceConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<NamespaceConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          NamespaceConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<NamespaceCondition> getConditions() {
        return build(conditions);
    }

    public List<NamespaceCondition> buildConditions() {
        return build(conditions);
    }

    public NamespaceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public NamespaceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public NamespaceCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public NamespaceCondition buildMatchingCondition(Predicate<NamespaceConditionBuilder> predicate) {
        for (NamespaceConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<NamespaceConditionBuilder> predicate) {
        for (NamespaceConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<NamespaceCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<NamespaceConditionBuilder>(); for (NamespaceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(NamespaceCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (NamespaceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)addToConditions(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
    }

    public NamespaceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public NamespaceStatusFluent.ConditionsNested<A> addNewConditionLike(NamespaceCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public NamespaceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,NamespaceCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public NamespaceStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public NamespaceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public NamespaceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public NamespaceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<NamespaceConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NamespaceStatusFluentImpl that = (NamespaceStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  phase,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends NamespaceConditionFluentImpl<NamespaceStatusFluent.ConditionsNested<N>> implements NamespaceStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,NamespaceCondition item) {
            this.index = index;
            this.builder = new NamespaceConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new NamespaceConditionBuilder(this);
        }

        public N and() {
             return (N) NamespaceStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


}
