package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class APIServiceSpecFluentImpl<A extends APIServiceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIServiceSpecFluent<A> {

    private String caBundle;
    private String group;
    private Integer groupPriorityMinimum;
    private Boolean insecureSkipTLSVerify;
    private ServiceReferenceBuilder service;
    private String version;
    private Integer versionPriority;

    public APIServiceSpecFluentImpl() { 
    }


    public APIServiceSpecFluentImpl(APIServiceSpec instance) { 
        this.withCaBundle(instance.getCaBundle()); 
        this.withGroup(instance.getGroup()); 
        this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum()); 
        this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify()); 
        this.withService(instance.getService()); 
        this.withVersion(instance.getVersion()); 
        this.withVersionPriority(instance.getVersionPriority()); 
    }


    public String getCaBundle() {
        return this.caBundle;
    }

    public A withCaBundle(String caBundle) {
        this.caBundle=caBundle; return (A) this;
    }

    public Boolean hasCaBundle() {
        return this.caBundle != null;
    }

    public A withNewCaBundle(String arg1) {
        return (A)withCaBundle(new String(arg1));
    }

    public A withNewCaBundle(StringBuilder arg1) {
        return (A)withCaBundle(new String(arg1));
    }

    public A withNewCaBundle(StringBuffer arg1) {
        return (A)withCaBundle(new String(arg1));
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group=group; return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1) {
        return (A)withGroup(new String(arg1));
    }

    public Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    public A withGroupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum=groupPriorityMinimum; return (A) this;
    }

    public Boolean hasGroupPriorityMinimum() {
        return this.groupPriorityMinimum != null;
    }

    public Boolean isInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify=insecureSkipTLSVerify; return (A) this;
    }

    public Boolean hasInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify != null;
    }

    public A withNewInsecureSkipTLSVerify(String arg1) {
        return (A)withInsecureSkipTLSVerify(new Boolean(arg1));
    }

    public A withNewInsecureSkipTLSVerify(boolean arg1) {
        return (A)withInsecureSkipTLSVerify(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildService instead.
 * @return The buildable object.
 */
@Deprecated public ServiceReference getService() {
        return this.service!=null?this.service.build():null;
    }

    public ServiceReference buildService() {
        return this.service!=null?this.service.build():null;
    }

    public A withService(ServiceReference service) {
        _visitables.get("service").remove(this.service);
        if (service!=null){ this.service= new ServiceReferenceBuilder(service); _visitables.get("service").add(this.service);} return (A) this;
    }

    public Boolean hasService() {
        return this.service != null;
    }

    public A withNewService(String name,String namespace,Integer port) {
        return (A)withService(new ServiceReference(name, namespace, port));
    }

    public APIServiceSpecFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    public APIServiceSpecFluent.ServiceNested<A> withNewServiceLike(ServiceReference item) {
        return new ServiceNestedImpl(item);
    }

    public APIServiceSpecFluent.ServiceNested<A> editService() {
        return withNewServiceLike(getService());
    }

    public APIServiceSpecFluent.ServiceNested<A> editOrNewService() {
        return withNewServiceLike(getService() != null ? getService(): new ServiceReferenceBuilder().build());
    }

    public APIServiceSpecFluent.ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
        return withNewServiceLike(getService() != null ? getService(): item);
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public Integer getVersionPriority() {
        return this.versionPriority;
    }

    public A withVersionPriority(Integer versionPriority) {
        this.versionPriority=versionPriority; return (A) this;
    }

    public Boolean hasVersionPriority() {
        return this.versionPriority != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIServiceSpecFluentImpl that = (APIServiceSpecFluentImpl) o;
        if (caBundle != null ? !caBundle.equals(that.caBundle) :that.caBundle != null) return false;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (groupPriorityMinimum != null ? !groupPriorityMinimum.equals(that.groupPriorityMinimum) :that.groupPriorityMinimum != null) return false;
        if (insecureSkipTLSVerify != null ? !insecureSkipTLSVerify.equals(that.insecureSkipTLSVerify) :that.insecureSkipTLSVerify != null) return false;
        if (service != null ? !service.equals(that.service) :that.service != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (versionPriority != null ? !versionPriority.equals(that.versionPriority) :that.versionPriority != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(caBundle,  group,  groupPriorityMinimum,  insecureSkipTLSVerify,  service,  version,  versionPriority,  super.hashCode());
    }

    public class ServiceNestedImpl<N> extends ServiceReferenceFluentImpl<APIServiceSpecFluent.ServiceNested<N>> implements APIServiceSpecFluent.ServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceReferenceBuilder builder;

        ServiceNestedImpl(ServiceReference item) {
            this.builder = new ServiceReferenceBuilder(this, item);
        }

        ServiceNestedImpl() {
            this.builder = new ServiceReferenceBuilder(this);
        }

        public N and() {
             return (N) APIServiceSpecFluentImpl.this.withService(builder.build());
        }

        public N endService() {
             return and();
        }
    }


}
