package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Deprecated;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.List;
import java.lang.Long;
import java.util.Collection;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

public class BaseKubernetesListFluentImpl<A extends BaseKubernetesListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BaseKubernetesListFluent<A> {

    private String apiVersion;
    private List<VisitableBuilder<? extends HasMetadata,?>> items =  new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();
    private String kind;
    private ListMetaBuilder metadata;

    public BaseKubernetesListFluentImpl() { 
    }


    public BaseKubernetesListFluentImpl(BaseKubernetesList instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(VisitableBuilder<? extends HasMetadata,?> builder) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        _visitables.get("items").add(builder);this.items.add(builder); return (A)this;
    }

    public A addToItems(int index,VisitableBuilder<? extends HasMetadata,?> builder) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        _visitables.get("items").add(index, builder);this.items.add(index, builder); return (A)this;
    }

    public A addToItems(int index,HasMetadata item) {
        if (item instanceof LimitRange){addToLimitRangeItems(index, (LimitRange)item);}
 else if (item instanceof APIService){addToAPIServiceItems(index, (APIService)item);}
 else if (item instanceof Namespace){addToNamespaceItems(index, (Namespace)item);}
 else if (item instanceof Service){addToServiceItems(index, (Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems(index, (ReplicationController)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems(index, (PodTemplate)item);}
 else if (item instanceof Event){addToEventItems(index, (Event)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems(index, (PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems(index, (PersistentVolumeClaim)item);}
 else if (item instanceof Endpoints){addToEndpointsItems(index, (Endpoints)item);}
 else if (item instanceof Pod){addToPodItems(index, (Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems(index, (ConfigMap)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems(index, (ComponentStatus)item);}
 else if (item instanceof Binding){addToBindingItems(index, (Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems(index, (ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems(index, (Secret)item);}
 else if (item instanceof Node){addToNodeItems(index, (Node)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems(index, (ServiceAccount)item);}

        return (A)this;
    }

    public A setToItems(int index,HasMetadata item) {
        if (item instanceof LimitRange){setToLimitRangeItems(index, (LimitRange)item);}
 else if (item instanceof APIService){setToAPIServiceItems(index, (APIService)item);}
 else if (item instanceof Namespace){setToNamespaceItems(index, (Namespace)item);}
 else if (item instanceof Service){setToServiceItems(index, (Service)item);}
 else if (item instanceof ReplicationController){setToReplicationControllerItems(index, (ReplicationController)item);}
 else if (item instanceof PodTemplate){setToPodTemplateItems(index, (PodTemplate)item);}
 else if (item instanceof Event){setToEventItems(index, (Event)item);}
 else if (item instanceof PersistentVolume){setToPersistentVolumeItems(index, (PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){setToPersistentVolumeClaimItems(index, (PersistentVolumeClaim)item);}
 else if (item instanceof Endpoints){setToEndpointsItems(index, (Endpoints)item);}
 else if (item instanceof Pod){setToPodItems(index, (Pod)item);}
 else if (item instanceof ConfigMap){setToConfigMapItems(index, (ConfigMap)item);}
 else if (item instanceof ComponentStatus){setToComponentStatusItems(index, (ComponentStatus)item);}
 else if (item instanceof Binding){setToBindingItems(index, (Binding)item);}
 else if (item instanceof ResourceQuota){setToResourceQuotaItems(index, (ResourceQuota)item);}
 else if (item instanceof Secret){setToSecretItems(index, (Secret)item);}
 else if (item instanceof Node){setToNodeItems(index, (Node)item);}
 else if (item instanceof ServiceAccount){setToServiceAccountItems(index, (ServiceAccount)item);}

        return (A)this;
    }

    public A addToItems(HasMetadata... items) {
         if (items != null && items.length > 0 && this.items== null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (HasMetadata item : items) { 
        if (item instanceof LimitRange){addToLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){addToAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){addToBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}

        else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").add(builder);this.items.add(builder); }
        } return (A)this;
    }

    public A addAllToItems(Collection<HasMetadata> items) {
         if (items != null && items.size() > 0 && this.items== null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (HasMetadata item : items) { 
        if (item instanceof LimitRange){addToLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){addToAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){addToBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}

        else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").add(builder);this.items.add(builder); }
        } return (A)this;
    }

    public A removeFromItems(VisitableBuilder<? extends HasMetadata,?> builder) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        _visitables.get("items").remove(builder);this.items.remove(builder); return (A)this;
    }

    public A removeFromItems(HasMetadata... items) {
        for (HasMetadata item : items) {if (item instanceof LimitRange){removeFromLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){removeFromAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof ConfigMap){removeFromConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){removeFromBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}

        else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").remove(builder);this.items.remove(builder); }
        } return (A)this;
    }

    public A removeAllFromItems(Collection<HasMetadata> items) {
        for (HasMetadata item : items) {if (item instanceof LimitRange){removeFromLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){removeFromAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof ConfigMap){removeFromConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){removeFromBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}

        else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").remove(builder);this.items.remove(builder); }
        } return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<HasMetadata> getItems() {
        return build(items);
    }

    public List<HasMetadata> buildItems() {
        return build(items);
    }

    public HasMetadata buildItem(int index) {
        return this.items.get(index).build();
    }

    public HasMetadata buildFirstItem() {
        return this.items.get(0).build();
    }

    public HasMetadata buildLastItem() {
        return this.items.get(items.size() - 1).build();
    }

    public HasMetadata buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        for (VisitableBuilder<? extends HasMetadata,?> item: items) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        for (VisitableBuilder<? extends HasMetadata,?> item: items) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withItems(List<HasMetadata> items) {
        if (this.items != null) { _visitables.get("items").removeAll(this.items);}
        if (items != null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>(); for (HasMetadata item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(HasMetadata... items) {
        if (this.items != null) {this.items.clear();}
        if (items != null) {for (HasMetadata item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems() {
        return items != null && !items.isEmpty();
    }

    public A addToLimitRangeItems(int index,LimitRange item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToLimitRangeItems(int index,LimitRange item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        LimitRangeBuilder builder = new LimitRangeBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToLimitRangeItems(LimitRange... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToLimitRangeItems(Collection<LimitRange> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromLimitRangeItems(LimitRange... items) {
        for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromLimitRangeItems(Collection<LimitRange> items) {
        for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromLimitRangeItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItem() {
        return new LimitRangeItemsNestedImpl();
    }

    public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItemLike(LimitRange item) {
        return new LimitRangeItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.LimitRangeItemsNested<A> setNewLimitRangeItemLike(int index,LimitRange item) {
        return new LimitRangeItemsNestedImpl(index, item);
    }

    public A addToAPIServiceItems(int index,APIService item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToAPIServiceItems(int index,APIService item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        APIServiceBuilder builder = new APIServiceBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToAPIServiceItems(APIService... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToAPIServiceItems(Collection<APIService> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromAPIServiceItems(APIService... items) {
        for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromAPIServiceItems(Collection<APIService> items) {
        for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAPIServiceItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItem() {
        return new APIServiceItemsNestedImpl();
    }

    public BaseKubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItemLike(APIService item) {
        return new APIServiceItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.APIServiceItemsNested<A> setNewAPIServiceItemLike(int index,APIService item) {
        return new APIServiceItemsNestedImpl(index, item);
    }

    public A addToNamespaceItems(int index,Namespace item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToNamespaceItems(int index,Namespace item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        NamespaceBuilder builder = new NamespaceBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToNamespaceItems(Namespace... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToNamespaceItems(Collection<Namespace> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromNamespaceItems(Namespace... items) {
        for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromNamespaceItems(Collection<Namespace> items) {
        for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromNamespaceItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItem() {
        return new NamespaceItemsNestedImpl();
    }

    public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItemLike(Namespace item) {
        return new NamespaceItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.NamespaceItemsNested<A> setNewNamespaceItemLike(int index,Namespace item) {
        return new NamespaceItemsNestedImpl(index, item);
    }

    public A addToServiceItems(int index,Service item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToServiceItems(int index,Service item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ServiceBuilder builder = new ServiceBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToServiceItems(Service... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToServiceItems(Collection<Service> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromServiceItems(Service... items) {
        for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromServiceItems(Collection<Service> items) {
        for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromServiceItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItem() {
        return new ServiceItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItemLike(Service item) {
        return new ServiceItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ServiceItemsNested<A> setNewServiceItemLike(int index,Service item) {
        return new ServiceItemsNestedImpl(index, item);
    }

    public A addToReplicationControllerItems(int index,ReplicationController item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToReplicationControllerItems(int index,ReplicationController item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToReplicationControllerItems(ReplicationController... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToReplicationControllerItems(Collection<ReplicationController> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromReplicationControllerItems(ReplicationController... items) {
        for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromReplicationControllerItems(Collection<ReplicationController> items) {
        for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromReplicationControllerItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItem() {
        return new ReplicationControllerItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(ReplicationController item) {
        return new ReplicationControllerItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> setNewReplicationControllerItemLike(int index,ReplicationController item) {
        return new ReplicationControllerItemsNestedImpl(index, item);
    }

    public A addToPodTemplateItems(int index,PodTemplate item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToPodTemplateItems(int index,PodTemplate item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        PodTemplateBuilder builder = new PodTemplateBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToPodTemplateItems(PodTemplate... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToPodTemplateItems(Collection<PodTemplate> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPodTemplateItems(PodTemplate... items) {
        for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromPodTemplateItems(Collection<PodTemplate> items) {
        for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPodTemplateItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItem() {
        return new PodTemplateItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItemLike(PodTemplate item) {
        return new PodTemplateItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.PodTemplateItemsNested<A> setNewPodTemplateItemLike(int index,PodTemplate item) {
        return new PodTemplateItemsNestedImpl(index, item);
    }

    public A addToEventItems(int index,Event item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        EventBuilder builder = new EventBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToEventItems(int index,Event item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        EventBuilder builder = new EventBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToEventItems(Event... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToEventItems(Collection<Event> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromEventItems(Event... items) {
        for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromEventItems(Collection<Event> items) {
        for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEventItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItem() {
        return new EventItemsNestedImpl();
    }

    public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItemLike(Event item) {
        return new EventItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.EventItemsNested<A> setNewEventItemLike(int index,Event item) {
        return new EventItemsNestedImpl(index, item);
    }

    public A addToPersistentVolumeItems(int index,PersistentVolume item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToPersistentVolumeItems(int index,PersistentVolume item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToPersistentVolumeItems(PersistentVolume... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToPersistentVolumeItems(Collection<PersistentVolume> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPersistentVolumeItems(PersistentVolume... items) {
        for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromPersistentVolumeItems(Collection<PersistentVolume> items) {
        for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPersistentVolumeItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem() {
        return new PersistentVolumeItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(PersistentVolume item) {
        return new PersistentVolumeItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> setNewPersistentVolumeItemLike(int index,PersistentVolume item) {
        return new PersistentVolumeItemsNestedImpl(index, item);
    }

    public A addToPersistentVolumeClaimItems(int index,PersistentVolumeClaim item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToPersistentVolumeClaimItems(int index,PersistentVolumeClaim item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToPersistentVolumeClaimItems(PersistentVolumeClaim... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPersistentVolumeClaimItems(PersistentVolumeClaim... items) {
        for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items) {
        for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPersistentVolumeClaimItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem() {
        return new PersistentVolumeClaimItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> setNewPersistentVolumeClaimItemLike(int index,PersistentVolumeClaim item) {
        return new PersistentVolumeClaimItemsNestedImpl(index, item);
    }

    public A addToEndpointsItems(int index,Endpoints item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToEndpointsItems(int index,Endpoints item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        EndpointsBuilder builder = new EndpointsBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToEndpointsItems(Endpoints... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToEndpointsItems(Collection<Endpoints> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromEndpointsItems(Endpoints... items) {
        for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromEndpointsItems(Collection<Endpoints> items) {
        for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEndpointsItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItem() {
        return new EndpointsItemsNestedImpl();
    }

    public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItemLike(Endpoints item) {
        return new EndpointsItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.EndpointsItemsNested<A> setNewEndpointsItemLike(int index,Endpoints item) {
        return new EndpointsItemsNestedImpl(index, item);
    }

    public A addToPodItems(int index,Pod item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        PodBuilder builder = new PodBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToPodItems(int index,Pod item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        PodBuilder builder = new PodBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToPodItems(Pod... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToPodItems(Collection<Pod> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPodItems(Pod... items) {
        for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromPodItems(Collection<Pod> items) {
        for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPodItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItem() {
        return new PodItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItemLike(Pod item) {
        return new PodItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.PodItemsNested<A> setNewPodItemLike(int index,Pod item) {
        return new PodItemsNestedImpl(index, item);
    }

    public A addToConfigMapItems(int index,ConfigMap item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToConfigMapItems(int index,ConfigMap item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ConfigMapBuilder builder = new ConfigMapBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToConfigMapItems(ConfigMap... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToConfigMapItems(Collection<ConfigMap> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromConfigMapItems(ConfigMap... items) {
        for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfigMapItems(Collection<ConfigMap> items) {
        for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfigMapItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItem() {
        return new ConfigMapItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItemLike(ConfigMap item) {
        return new ConfigMapItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ConfigMapItemsNested<A> setNewConfigMapItemLike(int index,ConfigMap item) {
        return new ConfigMapItemsNestedImpl(index, item);
    }

    public A addToComponentStatusItems(int index,ComponentStatus item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToComponentStatusItems(int index,ComponentStatus item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ComponentStatusBuilder builder = new ComponentStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToComponentStatusItems(ComponentStatus... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToComponentStatusItems(Collection<ComponentStatus> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromComponentStatusItems(ComponentStatus... items) {
        for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromComponentStatusItems(Collection<ComponentStatus> items) {
        for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromComponentStatusItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItem() {
        return new ComponentStatusItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(ComponentStatus item) {
        return new ComponentStatusItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> setNewComponentStatusItemLike(int index,ComponentStatus item) {
        return new ComponentStatusItemsNestedImpl(index, item);
    }

    public A addToBindingItems(int index,Binding item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToBindingItems(int index,Binding item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        BindingBuilder builder = new BindingBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToBindingItems(Binding... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToBindingItems(Collection<Binding> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromBindingItems(Binding... items) {
        for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromBindingItems(Collection<Binding> items) {
        for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBindingItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItem() {
        return new BindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItemLike(Binding item) {
        return new BindingItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.BindingItemsNested<A> setNewBindingItemLike(int index,Binding item) {
        return new BindingItemsNestedImpl(index, item);
    }

    public A addToResourceQuotaItems(int index,ResourceQuota item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToResourceQuotaItems(int index,ResourceQuota item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToResourceQuotaItems(ResourceQuota... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToResourceQuotaItems(Collection<ResourceQuota> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromResourceQuotaItems(ResourceQuota... items) {
        for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromResourceQuotaItems(Collection<ResourceQuota> items) {
        for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResourceQuotaItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItem() {
        return new ResourceQuotaItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(ResourceQuota item) {
        return new ResourceQuotaItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> setNewResourceQuotaItemLike(int index,ResourceQuota item) {
        return new ResourceQuotaItemsNestedImpl(index, item);
    }

    public A addToSecretItems(int index,Secret item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToSecretItems(int index,Secret item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        SecretBuilder builder = new SecretBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToSecretItems(Secret... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToSecretItems(Collection<Secret> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromSecretItems(Secret... items) {
        for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromSecretItems(Collection<Secret> items) {
        for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSecretItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItem() {
        return new SecretItemsNestedImpl();
    }

    public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItemLike(Secret item) {
        return new SecretItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.SecretItemsNested<A> setNewSecretItemLike(int index,Secret item) {
        return new SecretItemsNestedImpl(index, item);
    }

    public A addToNodeItems(int index,Node item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToNodeItems(int index,Node item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        NodeBuilder builder = new NodeBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToNodeItems(Node... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToNodeItems(Collection<Node> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromNodeItems(Node... items) {
        for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromNodeItems(Collection<Node> items) {
        for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromNodeItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItem() {
        return new NodeItemsNestedImpl();
    }

    public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItemLike(Node item) {
        return new NodeItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.NodeItemsNested<A> setNewNodeItemLike(int index,Node item) {
        return new NodeItemsNestedImpl(index, item);
    }

    public A addToServiceAccountItems(int index,ServiceAccount item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToServiceAccountItems(int index,ServiceAccount item) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        ServiceAccountBuilder builder = new ServiceAccountBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToServiceAccountItems(ServiceAccount... items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToServiceAccountItems(Collection<ServiceAccount> items) {
        if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
        for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromServiceAccountItems(ServiceAccount... items) {
        for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromServiceAccountItems(Collection<ServiceAccount> items) {
        for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromServiceAccountItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
        if (items == null) return (A) this;
        final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          VisitableBuilder<? extends HasMetadata,?> builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItem() {
        return new ServiceAccountItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(ServiceAccount item) {
        return new ServiceAccountItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> setNewServiceAccountItemLike(int index,ServiceAccount item) {
        return new ServiceAccountItemsNestedImpl(index, item);
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ListMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
        return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public BaseKubernetesListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public BaseKubernetesListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    public BaseKubernetesListFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ListMetaBuilder().build());
    }

    public BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BaseKubernetesListFluentImpl that = (BaseKubernetesListFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (items != null ? !items.equals(that.items) :that.items != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
    }

    public class LimitRangeItemsNestedImpl<N> extends LimitRangeFluentImpl<BaseKubernetesListFluent.LimitRangeItemsNested<N>> implements BaseKubernetesListFluent.LimitRangeItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LimitRangeBuilder builder;
        private final int index;

        LimitRangeItemsNestedImpl(int index,LimitRange item) {
            this.index = index;
            this.builder = new LimitRangeBuilder(this, item);
        }

        LimitRangeItemsNestedImpl() {
            this.index = -1;
            this.builder = new LimitRangeBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endLimitRangeItem() {
             return and();
        }
    }


    public class APIServiceItemsNestedImpl<N> extends APIServiceFluentImpl<BaseKubernetesListFluent.APIServiceItemsNested<N>> implements BaseKubernetesListFluent.APIServiceItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServiceBuilder builder;
        private final int index;

        APIServiceItemsNestedImpl(int index,APIService item) {
            this.index = index;
            this.builder = new APIServiceBuilder(this, item);
        }

        APIServiceItemsNestedImpl() {
            this.index = -1;
            this.builder = new APIServiceBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endAPIServiceItem() {
             return and();
        }
    }


    public class NamespaceItemsNestedImpl<N> extends NamespaceFluentImpl<BaseKubernetesListFluent.NamespaceItemsNested<N>> implements BaseKubernetesListFluent.NamespaceItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceBuilder builder;
        private final int index;

        NamespaceItemsNestedImpl(int index,Namespace item) {
            this.index = index;
            this.builder = new NamespaceBuilder(this, item);
        }

        NamespaceItemsNestedImpl() {
            this.index = -1;
            this.builder = new NamespaceBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endNamespaceItem() {
             return and();
        }
    }


    public class ServiceItemsNestedImpl<N> extends ServiceFluentImpl<BaseKubernetesListFluent.ServiceItemsNested<N>> implements BaseKubernetesListFluent.ServiceItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceBuilder builder;
        private final int index;

        ServiceItemsNestedImpl(int index,Service item) {
            this.index = index;
            this.builder = new ServiceBuilder(this, item);
        }

        ServiceItemsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endServiceItem() {
             return and();
        }
    }


    public class ReplicationControllerItemsNestedImpl<N> extends ReplicationControllerFluentImpl<BaseKubernetesListFluent.ReplicationControllerItemsNested<N>> implements BaseKubernetesListFluent.ReplicationControllerItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReplicationControllerBuilder builder;
        private final int index;

        ReplicationControllerItemsNestedImpl(int index,ReplicationController item) {
            this.index = index;
            this.builder = new ReplicationControllerBuilder(this, item);
        }

        ReplicationControllerItemsNestedImpl() {
            this.index = -1;
            this.builder = new ReplicationControllerBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endReplicationControllerItem() {
             return and();
        }
    }


    public class PodTemplateItemsNestedImpl<N> extends PodTemplateFluentImpl<BaseKubernetesListFluent.PodTemplateItemsNested<N>> implements BaseKubernetesListFluent.PodTemplateItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateBuilder builder;
        private final int index;

        PodTemplateItemsNestedImpl(int index,PodTemplate item) {
            this.index = index;
            this.builder = new PodTemplateBuilder(this, item);
        }

        PodTemplateItemsNestedImpl() {
            this.index = -1;
            this.builder = new PodTemplateBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endPodTemplateItem() {
             return and();
        }
    }


    public class EventItemsNestedImpl<N> extends EventFluentImpl<BaseKubernetesListFluent.EventItemsNested<N>> implements BaseKubernetesListFluent.EventItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventBuilder builder;
        private final int index;

        EventItemsNestedImpl(int index,Event item) {
            this.index = index;
            this.builder = new EventBuilder(this, item);
        }

        EventItemsNestedImpl() {
            this.index = -1;
            this.builder = new EventBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endEventItem() {
             return and();
        }
    }


    public class PersistentVolumeItemsNestedImpl<N> extends PersistentVolumeFluentImpl<BaseKubernetesListFluent.PersistentVolumeItemsNested<N>> implements BaseKubernetesListFluent.PersistentVolumeItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeBuilder builder;
        private final int index;

        PersistentVolumeItemsNestedImpl(int index,PersistentVolume item) {
            this.index = index;
            this.builder = new PersistentVolumeBuilder(this, item);
        }

        PersistentVolumeItemsNestedImpl() {
            this.index = -1;
            this.builder = new PersistentVolumeBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endPersistentVolumeItem() {
             return and();
        }
    }


    public class PersistentVolumeClaimItemsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>> implements BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimBuilder builder;
        private final int index;

        PersistentVolumeClaimItemsNestedImpl(int index,PersistentVolumeClaim item) {
            this.index = index;
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        PersistentVolumeClaimItemsNestedImpl() {
            this.index = -1;
            this.builder = new PersistentVolumeClaimBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endPersistentVolumeClaimItem() {
             return and();
        }
    }


    public class EndpointsItemsNestedImpl<N> extends EndpointsFluentImpl<BaseKubernetesListFluent.EndpointsItemsNested<N>> implements BaseKubernetesListFluent.EndpointsItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointsBuilder builder;
        private final int index;

        EndpointsItemsNestedImpl(int index,Endpoints item) {
            this.index = index;
            this.builder = new EndpointsBuilder(this, item);
        }

        EndpointsItemsNestedImpl() {
            this.index = -1;
            this.builder = new EndpointsBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endEndpointsItem() {
             return and();
        }
    }


    public class PodItemsNestedImpl<N> extends PodFluentImpl<BaseKubernetesListFluent.PodItemsNested<N>> implements BaseKubernetesListFluent.PodItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodBuilder builder;
        private final int index;

        PodItemsNestedImpl(int index,Pod item) {
            this.index = index;
            this.builder = new PodBuilder(this, item);
        }

        PodItemsNestedImpl() {
            this.index = -1;
            this.builder = new PodBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endPodItem() {
             return and();
        }
    }


    public class ConfigMapItemsNestedImpl<N> extends ConfigMapFluentImpl<BaseKubernetesListFluent.ConfigMapItemsNested<N>> implements BaseKubernetesListFluent.ConfigMapItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapBuilder builder;
        private final int index;

        ConfigMapItemsNestedImpl(int index,ConfigMap item) {
            this.index = index;
            this.builder = new ConfigMapBuilder(this, item);
        }

        ConfigMapItemsNestedImpl() {
            this.index = -1;
            this.builder = new ConfigMapBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endConfigMapItem() {
             return and();
        }
    }


    public class ComponentStatusItemsNestedImpl<N> extends ComponentStatusFluentImpl<BaseKubernetesListFluent.ComponentStatusItemsNested<N>> implements BaseKubernetesListFluent.ComponentStatusItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ComponentStatusBuilder builder;
        private final int index;

        ComponentStatusItemsNestedImpl(int index,ComponentStatus item) {
            this.index = index;
            this.builder = new ComponentStatusBuilder(this, item);
        }

        ComponentStatusItemsNestedImpl() {
            this.index = -1;
            this.builder = new ComponentStatusBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endComponentStatusItem() {
             return and();
        }
    }


    public class BindingItemsNestedImpl<N> extends BindingFluentImpl<BaseKubernetesListFluent.BindingItemsNested<N>> implements BaseKubernetesListFluent.BindingItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BindingBuilder builder;
        private final int index;

        BindingItemsNestedImpl(int index,Binding item) {
            this.index = index;
            this.builder = new BindingBuilder(this, item);
        }

        BindingItemsNestedImpl() {
            this.index = -1;
            this.builder = new BindingBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endBindingItem() {
             return and();
        }
    }


    public class ResourceQuotaItemsNestedImpl<N> extends ResourceQuotaFluentImpl<BaseKubernetesListFluent.ResourceQuotaItemsNested<N>> implements BaseKubernetesListFluent.ResourceQuotaItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceQuotaBuilder builder;
        private final int index;

        ResourceQuotaItemsNestedImpl(int index,ResourceQuota item) {
            this.index = index;
            this.builder = new ResourceQuotaBuilder(this, item);
        }

        ResourceQuotaItemsNestedImpl() {
            this.index = -1;
            this.builder = new ResourceQuotaBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endResourceQuotaItem() {
             return and();
        }
    }


    public class SecretItemsNestedImpl<N> extends SecretFluentImpl<BaseKubernetesListFluent.SecretItemsNested<N>> implements BaseKubernetesListFluent.SecretItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretBuilder builder;
        private final int index;

        SecretItemsNestedImpl(int index,Secret item) {
            this.index = index;
            this.builder = new SecretBuilder(this, item);
        }

        SecretItemsNestedImpl() {
            this.index = -1;
            this.builder = new SecretBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endSecretItem() {
             return and();
        }
    }


    public class NodeItemsNestedImpl<N> extends NodeFluentImpl<BaseKubernetesListFluent.NodeItemsNested<N>> implements BaseKubernetesListFluent.NodeItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodeBuilder builder;
        private final int index;

        NodeItemsNestedImpl(int index,Node item) {
            this.index = index;
            this.builder = new NodeBuilder(this, item);
        }

        NodeItemsNestedImpl() {
            this.index = -1;
            this.builder = new NodeBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endNodeItem() {
             return and();
        }
    }


    public class ServiceAccountItemsNestedImpl<N> extends ServiceAccountFluentImpl<BaseKubernetesListFluent.ServiceAccountItemsNested<N>> implements BaseKubernetesListFluent.ServiceAccountItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceAccountBuilder builder;
        private final int index;

        ServiceAccountItemsNestedImpl(int index,ServiceAccount item) {
            this.index = index;
            this.builder = new ServiceAccountBuilder(this, item);
        }

        ServiceAccountItemsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceAccountBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endServiceAccountItem() {
             return and();
        }
    }


    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<BaseKubernetesListFluent.MetadataNested<N>> implements BaseKubernetesListFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        public N and() {
             return (N) BaseKubernetesListFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


}
