package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TopologySelectorTermBuilder extends TopologySelectorTermFluentImpl<TopologySelectorTermBuilder> implements VisitableBuilder<TopologySelectorTerm,TopologySelectorTermBuilder> {

    TopologySelectorTermFluent<?> fluent;
    Boolean validationEnabled;

    public TopologySelectorTermBuilder() { 
        this(true);
    }


    public TopologySelectorTermBuilder(Boolean validationEnabled) { 
        this(new TopologySelectorTerm(), validationEnabled);
    }


    public TopologySelectorTermBuilder(TopologySelectorTermFluent<?> fluent) { 
        this(fluent, true);
    }


    public TopologySelectorTermBuilder(TopologySelectorTermFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TopologySelectorTerm(), validationEnabled);
    }


    public TopologySelectorTermBuilder(TopologySelectorTermFluent<?> fluent,TopologySelectorTerm instance) { 
        this(fluent, instance, true);
    }


    public TopologySelectorTermBuilder(TopologySelectorTermFluent<?> fluent,TopologySelectorTerm instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withMatchLabelExpressions(instance.getMatchLabelExpressions()); 
        this.validationEnabled = validationEnabled; 
    }


    public TopologySelectorTermBuilder(TopologySelectorTerm instance) { 
        this(instance,true);
    }


    public TopologySelectorTermBuilder(TopologySelectorTerm instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withMatchLabelExpressions(instance.getMatchLabelExpressions()); 
        this.validationEnabled = validationEnabled; 
    }


    public TopologySelectorTerm build() {
        TopologySelectorTerm buildable = new TopologySelectorTerm(fluent.getMatchLabelExpressions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TopologySelectorTermBuilder that = (TopologySelectorTermBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
