package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ServerAddressByClientCIDRFluentImpl<A extends ServerAddressByClientCIDRFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServerAddressByClientCIDRFluent<A> {

    private String clientCIDR;
    private String serverAddress;

    public ServerAddressByClientCIDRFluentImpl() { 
    }


    public ServerAddressByClientCIDRFluentImpl(ServerAddressByClientCIDR instance) { 
        this.withClientCIDR(instance.getClientCIDR()); 
        this.withServerAddress(instance.getServerAddress()); 
    }


    public String getClientCIDR() {
        return this.clientCIDR;
    }

    public A withClientCIDR(String clientCIDR) {
        this.clientCIDR=clientCIDR; return (A) this;
    }

    public Boolean hasClientCIDR() {
        return this.clientCIDR != null;
    }

    public A withNewClientCIDR(String arg1) {
        return (A)withClientCIDR(new String(arg1));
    }

    public A withNewClientCIDR(StringBuilder arg1) {
        return (A)withClientCIDR(new String(arg1));
    }

    public A withNewClientCIDR(StringBuffer arg1) {
        return (A)withClientCIDR(new String(arg1));
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public A withServerAddress(String serverAddress) {
        this.serverAddress=serverAddress; return (A) this;
    }

    public Boolean hasServerAddress() {
        return this.serverAddress != null;
    }

    public A withNewServerAddress(String arg1) {
        return (A)withServerAddress(new String(arg1));
    }

    public A withNewServerAddress(StringBuilder arg1) {
        return (A)withServerAddress(new String(arg1));
    }

    public A withNewServerAddress(StringBuffer arg1) {
        return (A)withServerAddress(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServerAddressByClientCIDRFluentImpl that = (ServerAddressByClientCIDRFluentImpl) o;
        if (clientCIDR != null ? !clientCIDR.equals(that.clientCIDR) :that.clientCIDR != null) return false;
        if (serverAddress != null ? !serverAddress.equals(that.serverAddress) :that.serverAddress != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clientCIDR,  serverAddress,  super.hashCode());
    }

}
