package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface APIServiceListFluent<A extends APIServiceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,APIService item);
    public A setToItems(int index,APIService item);
    public A addToItems(APIService... items);
    public A addAllToItems(Collection<APIService> items);
    public A removeFromItems(APIService... items);
    public A removeAllFromItems(Collection<APIService> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<APIServiceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<APIService> getItems();
    public List<APIService> buildItems();
    public APIService buildItem(int index);
    public APIService buildFirstItem();
    public APIService buildLastItem();
    public APIService buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<APIServiceBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<APIServiceBuilder> predicate);
    public A withItems(List<APIService> items);
    public A withItems(APIService... items);
    public Boolean hasItems();
    public APIServiceListFluent.ItemsNested<A> addNewItem();
    public APIServiceListFluent.ItemsNested<A> addNewItemLike(APIService item);
    public APIServiceListFluent.ItemsNested<A> setNewItemLike(int index,APIService item);
    public APIServiceListFluent.ItemsNested<A> editItem(int index);
    public APIServiceListFluent.ItemsNested<A> editFirstItem();
    public APIServiceListFluent.ItemsNested<A> editLastItem();
    public APIServiceListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<APIServiceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public APIServiceListFluent.MetadataNested<A> withNewMetadata();
    public APIServiceListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public APIServiceListFluent.MetadataNested<A> editMetadata();
    public APIServiceListFluent.MetadataNested<A> editOrNewMetadata();
    public APIServiceListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServiceFluent<APIServiceListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<APIServiceListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
