package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServiceConditionBuilder extends APIServiceConditionFluentImpl<APIServiceConditionBuilder> implements VisitableBuilder<APIServiceCondition,APIServiceConditionBuilder>{

    APIServiceConditionFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceConditionBuilder(){
            this(true);
    }
    public APIServiceConditionBuilder(Boolean validationEnabled){
            this(new APIServiceCondition(), validationEnabled);
    }
    public APIServiceConditionBuilder(APIServiceConditionFluent<?> fluent){
            this(fluent, true);
    }
    public APIServiceConditionBuilder(APIServiceConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new APIServiceCondition(), validationEnabled);
    }
    public APIServiceConditionBuilder(APIServiceConditionFluent<?> fluent,APIServiceCondition instance){
            this(fluent, instance, true);
    }
    public APIServiceConditionBuilder(APIServiceConditionFluent<?> fluent,APIServiceCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
            fluent.withMessage(instance.getMessage()); 
            fluent.withReason(instance.getReason()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public APIServiceConditionBuilder(APIServiceCondition instance){
            this(instance,true);
    }
    public APIServiceConditionBuilder(APIServiceCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withStatus(instance.getStatus()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public APIServiceCondition build(){
            APIServiceCondition buildable = new APIServiceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            APIServiceConditionBuilder that = (APIServiceConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
