package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GetOptionsBuilder extends GetOptionsFluentImpl<GetOptionsBuilder> implements VisitableBuilder<GetOptions,GetOptionsBuilder>{

    GetOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public GetOptionsBuilder(){
            this(true);
    }
    public GetOptionsBuilder(Boolean validationEnabled){
            this(new GetOptions(), validationEnabled);
    }
    public GetOptionsBuilder(GetOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public GetOptionsBuilder(GetOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GetOptions(), validationEnabled);
    }
    public GetOptionsBuilder(GetOptionsFluent<?> fluent,GetOptions instance){
            this(fluent, instance, true);
    }
    public GetOptionsBuilder(GetOptionsFluent<?> fluent,GetOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withResourceVersion(instance.getResourceVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public GetOptionsBuilder(GetOptions instance){
            this(instance,true);
    }
    public GetOptionsBuilder(GetOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withResourceVersion(instance.getResourceVersion()); 
            this.validationEnabled = validationEnabled; 
    }

    public GetOptions build(){
            GetOptions buildable = new GetOptions(fluent.getApiVersion(),fluent.getKind(),fluent.getResourceVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GetOptionsBuilder that = (GetOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
