package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.StringBuffer;

public interface BaseKubernetesListFluent<A extends BaseKubernetesListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(VisitableBuilder<? extends HasMetadata,?> builder);
    public A addToItems(int index,VisitableBuilder<? extends HasMetadata,?> builder);
    public A addToItems(int index,HasMetadata item);
    public A setToItems(int index,HasMetadata item);
    public A addToItems(HasMetadata... items);
    public A addAllToItems(Collection<HasMetadata> items);
    public A removeFromItems(VisitableBuilder<? extends HasMetadata,?> builder);
    public A removeFromItems(HasMetadata... items);
    public A removeAllFromItems(Collection<HasMetadata> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<HasMetadata> getItems();
    public List<HasMetadata> buildItems();
    public HasMetadata buildItem(int index);
    public HasMetadata buildFirstItem();
    public HasMetadata buildLastItem();
    public HasMetadata buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public A withItems(List<HasMetadata> items);
    public A withItems(HasMetadata... items);
    public Boolean hasItems();
    public A addToLimitRangeItems(int index,LimitRange item);
    public A setToLimitRangeItems(int index,LimitRange item);
    public A addToLimitRangeItems(LimitRange... items);
    public A addAllToLimitRangeItems(Collection<LimitRange> items);
    public A removeFromLimitRangeItems(LimitRange... items);
    public A removeAllFromLimitRangeItems(Collection<LimitRange> items);
    public A removeMatchingFromLimitRangeItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.LimitRangeItemsNested<A> setNewLimitRangeItemLike(int index,LimitRange item);
    public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItem();
    public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItemLike(LimitRange item);
    public A addToNamespaceItems(int index,Namespace item);
    public A setToNamespaceItems(int index,Namespace item);
    public A addToNamespaceItems(Namespace... items);
    public A addAllToNamespaceItems(Collection<Namespace> items);
    public A removeFromNamespaceItems(Namespace... items);
    public A removeAllFromNamespaceItems(Collection<Namespace> items);
    public A removeMatchingFromNamespaceItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.NamespaceItemsNested<A> setNewNamespaceItemLike(int index,Namespace item);
    public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItem();
    public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItemLike(Namespace item);
    public A addToServiceItems(int index,Service item);
    public A setToServiceItems(int index,Service item);
    public A addToServiceItems(Service... items);
    public A addAllToServiceItems(Collection<Service> items);
    public A removeFromServiceItems(Service... items);
    public A removeAllFromServiceItems(Collection<Service> items);
    public A removeMatchingFromServiceItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.ServiceItemsNested<A> setNewServiceItemLike(int index,Service item);
    public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItem();
    public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItemLike(Service item);
    public A addToReplicationControllerItems(int index,ReplicationController item);
    public A setToReplicationControllerItems(int index,ReplicationController item);
    public A addToReplicationControllerItems(ReplicationController... items);
    public A addAllToReplicationControllerItems(Collection<ReplicationController> items);
    public A removeFromReplicationControllerItems(ReplicationController... items);
    public A removeAllFromReplicationControllerItems(Collection<ReplicationController> items);
    public A removeMatchingFromReplicationControllerItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> setNewReplicationControllerItemLike(int index,ReplicationController item);
    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItem();
    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(ReplicationController item);
    public A addToPodTemplateItems(int index,PodTemplate item);
    public A setToPodTemplateItems(int index,PodTemplate item);
    public A addToPodTemplateItems(PodTemplate... items);
    public A addAllToPodTemplateItems(Collection<PodTemplate> items);
    public A removeFromPodTemplateItems(PodTemplate... items);
    public A removeAllFromPodTemplateItems(Collection<PodTemplate> items);
    public A removeMatchingFromPodTemplateItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.PodTemplateItemsNested<A> setNewPodTemplateItemLike(int index,PodTemplate item);
    public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItem();
    public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItemLike(PodTemplate item);
    public A addToPersistentVolumeItems(int index,PersistentVolume item);
    public A setToPersistentVolumeItems(int index,PersistentVolume item);
    public A addToPersistentVolumeItems(PersistentVolume... items);
    public A addAllToPersistentVolumeItems(Collection<PersistentVolume> items);
    public A removeFromPersistentVolumeItems(PersistentVolume... items);
    public A removeAllFromPersistentVolumeItems(Collection<PersistentVolume> items);
    public A removeMatchingFromPersistentVolumeItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> setNewPersistentVolumeItemLike(int index,PersistentVolume item);
    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem();
    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(PersistentVolume item);
    public A addToPersistentVolumeClaimItems(int index,PersistentVolumeClaim item);
    public A setToPersistentVolumeClaimItems(int index,PersistentVolumeClaim item);
    public A addToPersistentVolumeClaimItems(PersistentVolumeClaim... items);
    public A addAllToPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items);
    public A removeFromPersistentVolumeClaimItems(PersistentVolumeClaim... items);
    public A removeAllFromPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items);
    public A removeMatchingFromPersistentVolumeClaimItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> setNewPersistentVolumeClaimItemLike(int index,PersistentVolumeClaim item);
    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem();
    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(PersistentVolumeClaim item);
    public A addToEndpointsItems(int index,Endpoints item);
    public A setToEndpointsItems(int index,Endpoints item);
    public A addToEndpointsItems(Endpoints... items);
    public A addAllToEndpointsItems(Collection<Endpoints> items);
    public A removeFromEndpointsItems(Endpoints... items);
    public A removeAllFromEndpointsItems(Collection<Endpoints> items);
    public A removeMatchingFromEndpointsItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.EndpointsItemsNested<A> setNewEndpointsItemLike(int index,Endpoints item);
    public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItem();
    public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItemLike(Endpoints item);
    public A addToPodItems(int index,Pod item);
    public A setToPodItems(int index,Pod item);
    public A addToPodItems(Pod... items);
    public A addAllToPodItems(Collection<Pod> items);
    public A removeFromPodItems(Pod... items);
    public A removeAllFromPodItems(Collection<Pod> items);
    public A removeMatchingFromPodItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.PodItemsNested<A> setNewPodItemLike(int index,Pod item);
    public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItem();
    public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItemLike(Pod item);
    public A addToConfigMapItems(int index,ConfigMap item);
    public A setToConfigMapItems(int index,ConfigMap item);
    public A addToConfigMapItems(ConfigMap... items);
    public A addAllToConfigMapItems(Collection<ConfigMap> items);
    public A removeFromConfigMapItems(ConfigMap... items);
    public A removeAllFromConfigMapItems(Collection<ConfigMap> items);
    public A removeMatchingFromConfigMapItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.ConfigMapItemsNested<A> setNewConfigMapItemLike(int index,ConfigMap item);
    public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItem();
    public BaseKubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItemLike(ConfigMap item);
    public A addToComponentStatusItems(int index,ComponentStatus item);
    public A setToComponentStatusItems(int index,ComponentStatus item);
    public A addToComponentStatusItems(ComponentStatus... items);
    public A addAllToComponentStatusItems(Collection<ComponentStatus> items);
    public A removeFromComponentStatusItems(ComponentStatus... items);
    public A removeAllFromComponentStatusItems(Collection<ComponentStatus> items);
    public A removeMatchingFromComponentStatusItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> setNewComponentStatusItemLike(int index,ComponentStatus item);
    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItem();
    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(ComponentStatus item);
    public A addToBindingItems(int index,Binding item);
    public A setToBindingItems(int index,Binding item);
    public A addToBindingItems(Binding... items);
    public A addAllToBindingItems(Collection<Binding> items);
    public A removeFromBindingItems(Binding... items);
    public A removeAllFromBindingItems(Collection<Binding> items);
    public A removeMatchingFromBindingItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.BindingItemsNested<A> setNewBindingItemLike(int index,Binding item);
    public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItem();
    public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItemLike(Binding item);
    public A addToResourceQuotaItems(int index,ResourceQuota item);
    public A setToResourceQuotaItems(int index,ResourceQuota item);
    public A addToResourceQuotaItems(ResourceQuota... items);
    public A addAllToResourceQuotaItems(Collection<ResourceQuota> items);
    public A removeFromResourceQuotaItems(ResourceQuota... items);
    public A removeAllFromResourceQuotaItems(Collection<ResourceQuota> items);
    public A removeMatchingFromResourceQuotaItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> setNewResourceQuotaItemLike(int index,ResourceQuota item);
    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItem();
    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(ResourceQuota item);
    public A addToSecretItems(int index,Secret item);
    public A setToSecretItems(int index,Secret item);
    public A addToSecretItems(Secret... items);
    public A addAllToSecretItems(Collection<Secret> items);
    public A removeFromSecretItems(Secret... items);
    public A removeAllFromSecretItems(Collection<Secret> items);
    public A removeMatchingFromSecretItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.SecretItemsNested<A> setNewSecretItemLike(int index,Secret item);
    public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItem();
    public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItemLike(Secret item);
    public A addToNodeItems(int index,Node item);
    public A setToNodeItems(int index,Node item);
    public A addToNodeItems(Node... items);
    public A addAllToNodeItems(Collection<Node> items);
    public A removeFromNodeItems(Node... items);
    public A removeAllFromNodeItems(Collection<Node> items);
    public A removeMatchingFromNodeItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.NodeItemsNested<A> setNewNodeItemLike(int index,Node item);
    public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItem();
    public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItemLike(Node item);
    public A addToServiceAccountItems(int index,ServiceAccount item);
    public A setToServiceAccountItems(int index,ServiceAccount item);
    public A addToServiceAccountItems(ServiceAccount... items);
    public A addAllToServiceAccountItems(Collection<ServiceAccount> items);
    public A removeFromServiceAccountItems(ServiceAccount... items);
    public A removeAllFromServiceAccountItems(Collection<ServiceAccount> items);
    public A removeMatchingFromServiceAccountItems(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> setNewServiceAccountItemLike(int index,ServiceAccount item);
    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItem();
    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(ServiceAccount item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public BaseKubernetesListFluent.MetadataNested<A> withNewMetadata();
    public BaseKubernetesListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public BaseKubernetesListFluent.MetadataNested<A> editMetadata();
    public BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadata();
    public BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface LimitRangeItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LimitRangeFluent<BaseKubernetesListFluent.LimitRangeItemsNested<N>>{

        
    public N and();    public N endLimitRangeItem();
}
    public interface NamespaceItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceFluent<BaseKubernetesListFluent.NamespaceItemsNested<N>>{

        
    public N and();    public N endNamespaceItem();
}
    public interface ServiceItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceFluent<BaseKubernetesListFluent.ServiceItemsNested<N>>{

        
    public N and();    public N endServiceItem();
}
    public interface ReplicationControllerItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicationControllerFluent<BaseKubernetesListFluent.ReplicationControllerItemsNested<N>>{

        
    public N and();    public N endReplicationControllerItem();
}
    public interface PodTemplateItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateFluent<BaseKubernetesListFluent.PodTemplateItemsNested<N>>{

        
    public N and();    public N endPodTemplateItem();
}
    public interface PersistentVolumeItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeFluent<BaseKubernetesListFluent.PersistentVolumeItemsNested<N>>{

        
    public N and();    public N endPersistentVolumeItem();
}
    public interface PersistentVolumeClaimItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>>{

        
    public N and();    public N endPersistentVolumeClaimItem();
}
    public interface EndpointsItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointsFluent<BaseKubernetesListFluent.EndpointsItemsNested<N>>{

        
    public N and();    public N endEndpointsItem();
}
    public interface PodItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodFluent<BaseKubernetesListFluent.PodItemsNested<N>>{

        
    public N and();    public N endPodItem();
}
    public interface ConfigMapItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigMapFluent<BaseKubernetesListFluent.ConfigMapItemsNested<N>>{

        
    public N and();    public N endConfigMapItem();
}
    public interface ComponentStatusItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ComponentStatusFluent<BaseKubernetesListFluent.ComponentStatusItemsNested<N>>{

        
    public N and();    public N endComponentStatusItem();
}
    public interface BindingItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BindingFluent<BaseKubernetesListFluent.BindingItemsNested<N>>{

        
    public N and();    public N endBindingItem();
}
    public interface ResourceQuotaItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceQuotaFluent<BaseKubernetesListFluent.ResourceQuotaItemsNested<N>>{

        
    public N and();    public N endResourceQuotaItem();
}
    public interface SecretItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretFluent<BaseKubernetesListFluent.SecretItemsNested<N>>{

        
    public N and();    public N endSecretItem();
}
    public interface NodeItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeFluent<BaseKubernetesListFluent.NodeItemsNested<N>>{

        
    public N and();    public N endNodeItem();
}
    public interface ServiceAccountItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceAccountFluent<BaseKubernetesListFluent.ServiceAccountItemsNested<N>>{

        
    public N and();    public N endServiceAccountItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<BaseKubernetesListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
