package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface LeaseListFluent<A extends LeaseListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,Lease item);
  public A setToItems(Integer index,Lease item);
  public A addToItems(io.fabric8.kubernetes.api.model.coordination.v1.Lease... items);
  public A addAllToItems(Collection<Lease> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.coordination.v1.Lease... items);
  public A removeAllFromItems(Collection<Lease> items);
  public A removeMatchingFromItems(Predicate<LeaseBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Lease> getItems();
  public List<Lease> buildItems();
  public Lease buildItem(Integer index);
  public Lease buildFirstItem();
  public Lease buildLastItem();
  public Lease buildMatchingItem(Predicate<LeaseBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<LeaseBuilder> predicate);
  public A withItems(List<Lease> items);
  public A withItems(io.fabric8.kubernetes.api.model.coordination.v1.Lease... items);
  public Boolean hasItems();
  public LeaseListFluent.ItemsNested<A> addNewItem();
  public LeaseListFluent.ItemsNested<A> addNewItemLike(Lease item);
  public LeaseListFluent.ItemsNested<A> setNewItemLike(Integer index,Lease item);
  public LeaseListFluent.ItemsNested<A> editItem(Integer index);
  public LeaseListFluent.ItemsNested<A> editFirstItem();
  public LeaseListFluent.ItemsNested<A> editLastItem();
  public LeaseListFluent.ItemsNested<A> editMatchingItem(Predicate<LeaseBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,LeaseFluent<LeaseListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}