package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LeaseListBuilder extends LeaseListFluent<LeaseListBuilder> implements VisitableBuilder<LeaseList,LeaseListBuilder>{
  public LeaseListBuilder() {
    this(new LeaseList());
  }
  
  public LeaseListBuilder(LeaseListFluent<?> fluent) {
    this(fluent, new LeaseList());
  }
  
  public LeaseListBuilder(LeaseListFluent<?> fluent,LeaseList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LeaseListBuilder(LeaseList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LeaseListFluent<?> fluent;
  
  public LeaseList build() {
    LeaseList buildable = new LeaseList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}