package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LeaseBuilder extends LeaseFluentImpl<LeaseBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.coordination.v1.Lease,LeaseBuilder>{
  public LeaseBuilder() {
    this(false);
  }
  public LeaseBuilder(Boolean validationEnabled) {
    this(new Lease(), validationEnabled);
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent<?> fluent) {
    this(fluent, false);
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Lease(), validationEnabled);
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent<?> fluent,io.fabric8.kubernetes.api.model.coordination.v1.Lease instance) {
    this(fluent, instance, false);
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent<?> fluent,io.fabric8.kubernetes.api.model.coordination.v1.Lease instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.Lease instance) {
    this(instance,false);
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.Lease instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.coordination.v1.Lease build() {
    Lease buildable = new Lease(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}