package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface LeaseFluent<A extends LeaseFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public LeaseFluent.MetadataNested<A> withNewMetadata();
    public LeaseFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public LeaseFluent.MetadataNested<A> editMetadata();
    public LeaseFluent.MetadataNested<A> editOrNewMetadata();
    public LeaseFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public LeaseSpec getSpec();
    public LeaseSpec buildSpec();
    public A withSpec(LeaseSpec spec);
    public Boolean hasSpec();
    public LeaseFluent.SpecNested<A> withNewSpec();
    public LeaseFluent.SpecNested<A> withNewSpecLike(LeaseSpec item);
    public LeaseFluent.SpecNested<A> editSpec();
    public LeaseFluent.SpecNested<A> editOrNewSpec();
    public LeaseFluent.SpecNested<A> editOrNewSpecLike(LeaseSpec item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<LeaseFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LeaseSpecFluent<LeaseFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


}
