package io.fabric8.kubernetes.api.model.coordination.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.lang.StringBuffer;
import java.time.ZonedDateTime;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class LeaseSpecFluentImpl<A extends LeaseSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LeaseSpecFluent<A>{

    private ZonedDateTime acquireTime;
    private String holderIdentity;
    private Integer leaseDurationSeconds;
    private Integer leaseTransitions;
    private ZonedDateTime renewTime;
    private Map<String,Object> additionalProperties;

    public LeaseSpecFluentImpl(){
    }
    public LeaseSpecFluentImpl(LeaseSpec instance){
            this.withAcquireTime(instance.getAcquireTime()); 
            this.withHolderIdentity(instance.getHolderIdentity()); 
            this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds()); 
            this.withLeaseTransitions(instance.getLeaseTransitions()); 
            this.withRenewTime(instance.getRenewTime()); 
            this.withAdditionalProperties(instance.getAdditionalProperties());

    }

    public ZonedDateTime getAcquireTime(){
            return this.acquireTime;
    }

    public A withAcquireTime(ZonedDateTime acquireTime){
            this.acquireTime=acquireTime; return (A) this;
    }

    public Boolean hasAcquireTime(){
            return this.acquireTime != null;
    }

    public String getHolderIdentity(){
            return this.holderIdentity;
    }

    public A withHolderIdentity(String holderIdentity){
            this.holderIdentity=holderIdentity; return (A) this;
    }

    public Boolean hasHolderIdentity(){
            return this.holderIdentity != null;
    }

    public A withNewHolderIdentity(String arg1){
            return (A)withHolderIdentity(new String(arg1));
    }

    public A withNewHolderIdentity(StringBuilder arg1){
            return (A)withHolderIdentity(new String(arg1));
    }

    public A withNewHolderIdentity(StringBuffer arg1){
            return (A)withHolderIdentity(new String(arg1));
    }

    public Integer getLeaseDurationSeconds(){
            return this.leaseDurationSeconds;
    }

    public A withLeaseDurationSeconds(Integer leaseDurationSeconds){
            this.leaseDurationSeconds=leaseDurationSeconds; return (A) this;
    }

    public Boolean hasLeaseDurationSeconds(){
            return this.leaseDurationSeconds != null;
    }

    public Integer getLeaseTransitions(){
            return this.leaseTransitions;
    }

    public A withLeaseTransitions(Integer leaseTransitions){
            this.leaseTransitions=leaseTransitions; return (A) this;
    }

    public Boolean hasLeaseTransitions(){
            return this.leaseTransitions != null;
    }

    public ZonedDateTime getRenewTime(){
            return this.renewTime;
    }

    public A withRenewTime(ZonedDateTime renewTime){
            this.renewTime=renewTime; return (A) this;
    }

    public Boolean hasRenewTime(){
            return this.renewTime != null;
    }

    public A addToAdditionalProperties(String key,Object value){
            if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
    }

    public A addToAdditionalProperties(Map<String,Object> map){
            if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
    }

    public A removeFromAdditionalProperties(String key){
            if(this.additionalProperties == null) { return (A) this; }
            if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String,Object> map){
            if(this.additionalProperties == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getAdditionalProperties(){
            return this.additionalProperties;
    }

    public A withAdditionalProperties(Map<String,Object> additionalProperties){
            if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap<String,Object>(additionalProperties);} return (A) this;
    }

    public Boolean hasAdditionalProperties(){
            return this.additionalProperties != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            LeaseSpecFluentImpl that = (LeaseSpecFluentImpl) o;
            if (acquireTime != null ? !acquireTime.equals(that.acquireTime) :that.acquireTime != null) return false;
            if (holderIdentity != null ? !holderIdentity.equals(that.holderIdentity) :that.holderIdentity != null) return false;
            if (leaseDurationSeconds != null ? !leaseDurationSeconds.equals(that.leaseDurationSeconds) :that.leaseDurationSeconds != null) return false;
            if (leaseTransitions != null ? !leaseTransitions.equals(that.leaseTransitions) :that.leaseTransitions != null) return false;
            if (renewTime != null ? !renewTime.equals(that.renewTime) :that.renewTime != null) return false;
            if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
            return true;
    }




}
