/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.model.util;

import io.fabric8.kubernetes.model.annotation.ApiGroup;
import io.fabric8.kubernetes.model.annotation.ApiVersion;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Scanner;

public class Helper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadJson(String path) {
        try (InputStream resourceAsStream = Helper.class.getResourceAsStream(path);){
            Scanner scanner = new Scanner(resourceAsStream).useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getAnnotationValue(Class kubernetesResourceType, Class annotationClass) {
        Annotation annotation = Helper.getAnnotation(kubernetesResourceType, annotationClass);
        if (annotation instanceof ApiGroup) {
            return ((ApiGroup)annotation).value();
        }
        if (annotation instanceof ApiVersion) {
            return ((ApiVersion)annotation).value();
        }
        return null;
    }

    private static Annotation getAnnotation(Class kubernetesResourceType, Class annotationClass) {
        return Arrays.stream(kubernetesResourceType.getAnnotations()).filter(annotation -> annotation.annotationType().equals(annotationClass)).findFirst().orElse(null);
    }
}

