package io.fabric8.kubernetes.api.model.certificates.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateSigningRequestStatusBuilder extends CertificateSigningRequestStatusFluent<CertificateSigningRequestStatusBuilder> implements VisitableBuilder<CertificateSigningRequestStatus,CertificateSigningRequestStatusBuilder>{
  public CertificateSigningRequestStatusBuilder() {
    this(false);
  }
  public CertificateSigningRequestStatusBuilder(Boolean validationEnabled) {
    this(new CertificateSigningRequestStatus(), validationEnabled);
  }
  public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateSigningRequestStatus(), validationEnabled);
  }
  public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatusFluent<?> fluent,CertificateSigningRequestStatus instance) {
    this(fluent, instance, false);
  }
  public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatusFluent<?> fluent,CertificateSigningRequestStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateSigningRequestStatus());

    if (instance != null) {
      fluent.withCertificate(instance.getCertificate());
      fluent.withConditions(instance.getConditions());
      fluent.withCertificate(instance.getCertificate());
      fluent.withConditions(instance.getConditions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatus instance) {
    this(instance,false);
  }
  public CertificateSigningRequestStatusBuilder(CertificateSigningRequestStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateSigningRequestStatus());

    if (instance != null) {
      this.withCertificate(instance.getCertificate());
      this.withConditions(instance.getConditions());
      this.withCertificate(instance.getCertificate());
      this.withConditions(instance.getConditions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateSigningRequestStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateSigningRequestStatus build() {
    CertificateSigningRequestStatus buildable = new CertificateSigningRequestStatus(fluent.getCertificate(),fluent.buildConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}