package io.fabric8.kubernetes.api.model.certificates.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateSigningRequestSpecBuilder extends CertificateSigningRequestSpecFluent<CertificateSigningRequestSpecBuilder> implements VisitableBuilder<CertificateSigningRequestSpec,CertificateSigningRequestSpecBuilder>{
  public CertificateSigningRequestSpecBuilder() {
    this(false);
  }
  public CertificateSigningRequestSpecBuilder(Boolean validationEnabled) {
    this(new CertificateSigningRequestSpec(), validationEnabled);
  }
  public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateSigningRequestSpec(), validationEnabled);
  }
  public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent,CertificateSigningRequestSpec instance) {
    this(fluent, instance, false);
  }
  public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent,CertificateSigningRequestSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateSigningRequestSpec());

    if (instance != null) {
      fluent.withExpirationSeconds(instance.getExpirationSeconds());
      fluent.withExtra(instance.getExtra());
      fluent.withGroups(instance.getGroups());
      fluent.withRequest(instance.getRequest());
      fluent.withSignerName(instance.getSignerName());
      fluent.withUid(instance.getUid());
      fluent.withUsages(instance.getUsages());
      fluent.withUsername(instance.getUsername());
      fluent.withExpirationSeconds(instance.getExpirationSeconds());
      fluent.withExtra(instance.getExtra());
      fluent.withGroups(instance.getGroups());
      fluent.withRequest(instance.getRequest());
      fluent.withSignerName(instance.getSignerName());
      fluent.withUid(instance.getUid());
      fluent.withUsages(instance.getUsages());
      fluent.withUsername(instance.getUsername());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpec instance) {
    this(instance,false);
  }
  public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateSigningRequestSpec());

    if (instance != null) {
      this.withExpirationSeconds(instance.getExpirationSeconds());
      this.withExtra(instance.getExtra());
      this.withGroups(instance.getGroups());
      this.withRequest(instance.getRequest());
      this.withSignerName(instance.getSignerName());
      this.withUid(instance.getUid());
      this.withUsages(instance.getUsages());
      this.withUsername(instance.getUsername());
      this.withExpirationSeconds(instance.getExpirationSeconds());
      this.withExtra(instance.getExtra());
      this.withGroups(instance.getGroups());
      this.withRequest(instance.getRequest());
      this.withSignerName(instance.getSignerName());
      this.withUid(instance.getUid());
      this.withUsages(instance.getUsages());
      this.withUsername(instance.getUsername());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateSigningRequestSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateSigningRequestSpec build() {
    CertificateSigningRequestSpec buildable = new CertificateSigningRequestSpec(fluent.getExpirationSeconds(),fluent.getExtra(),fluent.getGroups(),fluent.getRequest(),fluent.getSignerName(),fluent.getUid(),fluent.getUsages(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}