package io.fabric8.kubernetes.api.model.certificates.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterTrustBundleSpecBuilder extends ClusterTrustBundleSpecFluent<ClusterTrustBundleSpecBuilder> implements VisitableBuilder<ClusterTrustBundleSpec,ClusterTrustBundleSpecBuilder>{
  public ClusterTrustBundleSpecBuilder() {
    this(false);
  }
  public ClusterTrustBundleSpecBuilder(Boolean validationEnabled) {
    this(new ClusterTrustBundleSpec(), validationEnabled);
  }
  public ClusterTrustBundleSpecBuilder(ClusterTrustBundleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterTrustBundleSpecBuilder(ClusterTrustBundleSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterTrustBundleSpec(), validationEnabled);
  }
  public ClusterTrustBundleSpecBuilder(ClusterTrustBundleSpecFluent<?> fluent,ClusterTrustBundleSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterTrustBundleSpecBuilder(ClusterTrustBundleSpecFluent<?> fluent,ClusterTrustBundleSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterTrustBundleSpec());

    if (instance != null) {
      fluent.withSignerName(instance.getSignerName());
      fluent.withTrustBundle(instance.getTrustBundle());
      fluent.withSignerName(instance.getSignerName());
      fluent.withTrustBundle(instance.getTrustBundle());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterTrustBundleSpecBuilder(ClusterTrustBundleSpec instance) {
    this(instance,false);
  }
  public ClusterTrustBundleSpecBuilder(ClusterTrustBundleSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterTrustBundleSpec());

    if (instance != null) {
      this.withSignerName(instance.getSignerName());
      this.withTrustBundle(instance.getTrustBundle());
      this.withSignerName(instance.getSignerName());
      this.withTrustBundle(instance.getTrustBundle());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterTrustBundleSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterTrustBundleSpec build() {
    ClusterTrustBundleSpec buildable = new ClusterTrustBundleSpec(fluent.getSignerName(),fluent.getTrustBundle());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}