package io.fabric8.kubernetes.api.model.certificates.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterTrustBundleBuilder extends ClusterTrustBundleFluent<ClusterTrustBundleBuilder> implements VisitableBuilder<ClusterTrustBundle,ClusterTrustBundleBuilder>{
  public ClusterTrustBundleBuilder() {
    this(false);
  }
  public ClusterTrustBundleBuilder(Boolean validationEnabled) {
    this(new ClusterTrustBundle(), validationEnabled);
  }
  public ClusterTrustBundleBuilder(ClusterTrustBundleFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterTrustBundleBuilder(ClusterTrustBundleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterTrustBundle(), validationEnabled);
  }
  public ClusterTrustBundleBuilder(ClusterTrustBundleFluent<?> fluent,ClusterTrustBundle instance) {
    this(fluent, instance, false);
  }
  public ClusterTrustBundleBuilder(ClusterTrustBundleFluent<?> fluent,ClusterTrustBundle instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterTrustBundle());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterTrustBundleBuilder(ClusterTrustBundle instance) {
    this(instance,false);
  }
  public ClusterTrustBundleBuilder(ClusterTrustBundle instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterTrustBundle());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterTrustBundleFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterTrustBundle build() {
    ClusterTrustBundle buildable = new ClusterTrustBundle(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}