package io.fabric8.kubernetes.api.model.certificates.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateSigningRequestConditionBuilder extends CertificateSigningRequestConditionFluentImpl<CertificateSigningRequestConditionBuilder> implements VisitableBuilder<CertificateSigningRequestCondition,CertificateSigningRequestConditionBuilder>{
  public CertificateSigningRequestConditionBuilder() {
    this(false);
  }
  public CertificateSigningRequestConditionBuilder(Boolean validationEnabled) {
    this(new CertificateSigningRequestCondition(), validationEnabled);
  }
  public CertificateSigningRequestConditionBuilder(CertificateSigningRequestConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSigningRequestConditionBuilder(CertificateSigningRequestConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateSigningRequestCondition(), validationEnabled);
  }
  public CertificateSigningRequestConditionBuilder(CertificateSigningRequestConditionFluent<?> fluent,CertificateSigningRequestCondition instance) {
    this(fluent, instance, false);
  }
  public CertificateSigningRequestConditionBuilder(CertificateSigningRequestConditionFluent<?> fluent,CertificateSigningRequestCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateSigningRequestConditionBuilder(CertificateSigningRequestCondition instance) {
    this(instance,false);
  }
  public CertificateSigningRequestConditionBuilder(CertificateSigningRequestCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateSigningRequestConditionFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateSigningRequestCondition build() {
    CertificateSigningRequestCondition buildable = new CertificateSigningRequestCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}